/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableShort;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableShort
extends ObservableShort {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Short>> observable;

    public RxObservableShort(Observable<Optional<Short>> observable) {
        this.observable = observable;
    }

    public RxObservableShort(short value, Observable<Optional<Short>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableShort(BehaviorSubject<Optional<Short>> subject) {
        super(RxObservableShort.safe((Optional<Short>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static short safe(Optional<Short> value) {
        return Utils.safe(value == null ? null : (Short)value.orElse(null));
    }

    @Deprecated
    public void set(short value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableShort.safe((Optional<Short>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

