/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableFloat;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableFloat
extends ObservableFloat {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Float>> observable;

    public RxObservableFloat(Observable<Optional<Float>> observable) {
        this.observable = observable;
    }

    public RxObservableFloat(float value, Observable<Optional<Float>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableFloat(BehaviorSubject<Optional<Float>> subject) {
        super(RxObservableFloat.safe((Optional<Float>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static float safe(Optional<Float> value) {
        return Utils.safe(value == null ? null : (Float)value.orElse(null));
    }

    @Deprecated
    public void set(float value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableFloat.safe((Optional<Float>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

