/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableByte;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableByte
extends ObservableByte {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Byte>> observable;

    public RxObservableByte(Observable<Optional<Byte>> observable) {
        this.observable = observable;
    }

    public RxObservableByte(byte value, Observable<Optional<Byte>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableByte(BehaviorSubject<Optional<Byte>> subject) {
        super(RxObservableByte.safe((Optional<Byte>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static byte safe(Optional<Byte> value) {
        return (Byte)Utils.safe((Object)(value == null ? null : (Byte)value.orElse(null)), (Object)0);
    }

    @Deprecated
    public void set(byte value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableByte.safe((Optional<Byte>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

