/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableField;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;

public class RxObservableField<T>
extends ObservableField<T> {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private final Observable<Optional<T>> observable;

    public RxObservableField(Observable<Optional<T>> observable) {
        this.observable = observable;
    }

    public RxObservableField(T value, Observable<Optional<T>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableField(BehaviorSubject<Optional<T>> subject) {
        super(RxObservableField.safe((Optional)subject.getValue()));
        this.observable = subject;
    }

    private static <T> T safe(Optional<T> value) {
        return (T)(value == null ? null : value.orElse(null));
    }

    private void safeSet(Optional<T> value) {
        super.set(RxObservableField.safe(value));
    }

    @Deprecated
    public void set(T value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(this::safeSet);
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

