/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableDouble;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableDouble
extends ObservableDouble {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Double>> observable;

    public RxObservableDouble(Observable<Optional<Double>> observable) {
        this.observable = observable;
    }

    public RxObservableDouble(double value, Observable<Optional<Double>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableDouble(BehaviorSubject<Optional<Double>> subject) {
        super(RxObservableDouble.safe((Optional<Double>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static double safe(Optional<Double> value) {
        return Utils.safe(value == null ? null : (Double)value.orElse(null));
    }

    @Deprecated
    public void set(double value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableDouble.safe((Optional<Double>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

