/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import android.databinding.BaseObservable;
import android.databinding.Observable;
import android.databinding.ObservableBoolean;
import android.databinding.ObservableByte;
import android.databinding.ObservableChar;
import android.databinding.ObservableDouble;
import android.databinding.ObservableField;
import android.databinding.ObservableFloat;
import android.databinding.ObservableInt;
import android.databinding.ObservableList;
import android.databinding.ObservableLong;
import android.databinding.ObservableShort;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxDataBinding {
    private RxDataBinding() {
    }

    public static io.reactivex.Observable<Boolean> asObservable(final ObservableBoolean field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Integer> asObservable(final ObservableInt field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Long> asObservable(final ObservableLong field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Short> asObservable(final ObservableShort field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Float> asObservable(final ObservableFloat field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)Float.valueOf(field.get()));
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)Float.valueOf(field.get()));
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Double> asObservable(final ObservableDouble field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Character> asObservable(final ObservableChar field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)Character.valueOf(field.get()));
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)Character.valueOf(field.get()));
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static io.reactivex.Observable<Byte> asObservable(final ObservableByte field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field.get());
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field.get());
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static <T> io.reactivex.Observable<Optional<T>> asObservable(final ObservableField<T> field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)Optional.ofNullable((Object)field.get()));
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)Optional.ofNullable((Object)field.get()));
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static <T extends BaseObservable> io.reactivex.Observable<T> asObservable(final T field) {
        return io.reactivex.Observable.create(emitter -> {
            Observable.OnPropertyChangedCallback callback = new Observable.OnPropertyChangedCallback(){

                public void onPropertyChanged(Observable sender, int propertyId) {
                    emitter.onNext((Object)field);
                }
            };
            emitter.setCancellable(() -> field.removeOnPropertyChangedCallback(callback));
            emitter.onNext((Object)field);
            field.addOnPropertyChangedCallback(callback);
        });
    }

    public static <T> io.reactivex.Observable<ListChange<T>> asObservable(ObservableList<T> list) {
        return io.reactivex.Observable.create(emitter -> {
            ObservableList.OnListChangedCallback callback = new ObservableList.OnListChangedCallback<ObservableList<T>>(){

                public void onChanged(ObservableList<T> ts) {
                    this.next(new ListChange(ts));
                }

                public void onItemRangeChanged(ObservableList<T> ts, int i, int i1) {
                    this.next(ListChange.changed(ts, i, i1));
                }

                public void onItemRangeInserted(ObservableList<T> ts, int i, int i1) {
                    this.next(ListChange.inserted(ts, i, i1));
                }

                public void onItemRangeMoved(ObservableList<T> ts, int i, int i1, int i2) {
                    this.next(ListChange.moved(ts, i, i1, i2));
                }

                public void onItemRangeRemoved(ObservableList<T> ts, int i, int i1) {
                    this.next(ListChange.removed(ts, i, i1));
                }

                private void next(ListChange<T> change) {
                    emitter.onNext(change);
                }
            };
            emitter.setCancellable(() -> RxDataBinding.lambda$null$20(list, (ObservableList.OnListChangedCallback)callback));
            emitter.onNext(new ListChange(list));
            list.addOnListChangedCallback(callback);
        });
    }

    public static <T> Observer<? super T> field(final ObservableField<T> field) {
        return new Observer<T>(){

            public void onComplete() {
            }

            public void onSubscribe(Disposable d) {
            }

            public void onError(Throwable e) {
            }

            public void onNext(T data) {
                field.set(data);
            }
        };
    }

    public static Observer<Integer> field(final ObservableInt field) {
        return new Observer<Integer>(){

            public void onComplete() {
            }

            public void onSubscribe(Disposable d) {
            }

            public void onError(Throwable e) {
            }

            public void onNext(Integer data) {
                field.set(Utils.safe((Integer)data));
            }
        };
    }

    public static <T> Consumer<List<? extends T>> listConsumer(ObservableList<T> list) {
        return data -> Utils.merge((List)list, (List)data);
    }

    public static <T> ObservableTransformer<T, T> loadingNext(ObservableBoolean loading) {
        return observable -> observable.doOnSubscribe(d -> loading.set(true)).doOnNext(t -> loading.set(false));
    }

    public static <T> ObservableTransformer<T, T> error(ObservableBoolean error) {
        return observable -> observable.doOnNext(t -> error.set(false)).doOnError(th -> error.set(true));
    }

    public static <T> void setField(ObservableField<T> field, T data) {
        if (field.get() != data) {
            field.set(data);
        } else {
            field.notifyChange();
        }
    }

    public static void setField(ObservableBoolean field, boolean data) {
        if (field.get() != data) {
            field.set(data);
        } else {
            field.notifyChange();
        }
    }

    private static /* synthetic */ void lambda$null$20(ObservableList list, ObservableList.OnListChangedCallback callback) throws Exception {
        list.removeOnListChangedCallback(callback);
    }

    public static class ListChange<T> {
        public static final int ALL = 0;
        public static final int CHANGED = 1;
        public static final int INSERTED = 2;
        public static final int MOVED = 3;
        public static final int REMOVED = 4;
        private ObservableList<T> list;
        private int action;
        public int start;
        public int count;
        public int to;

        public ObservableList<T> getList() {
            return this.list;
        }

        public int getAction() {
            return this.action;
        }

        public boolean isAction(int action) {
            return this.action == action;
        }

        public int getStart() {
            return this.start;
        }

        public int getCount() {
            return this.count;
        }

        public int getTo() {
            return this.to;
        }

        public ListChange(ObservableList<T> ts) {
            this.list = ts;
        }

        public static <T> ListChange<T> changed(ObservableList<T> ts, int start, int count) {
            ListChange<T> change = new ListChange<T>(ts);
            change.action = 1;
            change.start = start;
            change.count = count;
            return change;
        }

        public static <T> ListChange<T> moved(ObservableList<T> ts, int start, int to, int count) {
            ListChange<T> change = new ListChange<T>(ts);
            change.action = 3;
            change.start = start;
            change.to = to;
            change.count = count;
            return change;
        }

        public static <T> ListChange<T> inserted(ObservableList<T> ts, int start, int count) {
            ListChange<T> change = new ListChange<T>(ts);
            change.action = 2;
            change.start = start;
            change.count = count;
            return change;
        }

        public static <T> ListChange<T> removed(ObservableList<T> ts, int start, int count) {
            ListChange<T> change = new ListChange<T>(ts);
            change.action = 4;
            change.start = start;
            change.count = count;
            return change;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Action {
        }
    }
}

