/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import android.databinding.Observable;
import android.databinding.ObservableBoolean;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class TwoWayRxObservableBoolean
extends ObservableBoolean {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private final Observable<Optional<Boolean>> observable;
    private final Subject<Boolean> subject;

    public TwoWayRxObservableBoolean(Observable<Optional<Boolean>> observable) {
        this.observable = observable;
        this.subject = PublishSubject.create();
    }

    public TwoWayRxObservableBoolean(boolean value, Observable<Optional<Boolean>> observable) {
        super(value);
        this.observable = observable;
        this.subject = PublishSubject.create();
    }

    private static Boolean safe(Optional<Boolean> value) {
        return Utils.safe(value == null ? null : (Boolean)value.orElse(null));
    }

    public void set(boolean value) {
        if (value != this.get()) {
            super.set(value);
            this.subject.onNext((Object)value);
        }
    }

    public void silentSet(boolean value) {
        super.set(value);
    }

    public Observable<Boolean> asObservable() {
        return this.subject;
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> this.silentSet(TwoWayRxObservableBoolean.safe((Optional<Boolean>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.size() == 0 && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

