/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.WorldIdentifier;

final class WorldIdentifierImpl
implements WorldIdentifier {
    private static final IntPredicate NAMESPACE_PREDICATE = value -> value == 95 || value == 45 || value >= 97 && value <= 122 || value >= 48 && value <= 57 || value == 46;
    private static final IntPredicate VALUE_PREDICATE = value -> value == 95 || value == 45 || value >= 97 && value <= 122 || value >= 48 && value <= 57 || value == 47 || value == 46;
    private final String namespace;
    private final String value;

    WorldIdentifierImpl(String namespace, String value) {
        if (WorldIdentifierImpl.fails(NAMESPACE_PREDICATE, namespace)) {
            throw new IllegalArgumentException(String.format("Non [a-z0-9_.-] character in namespace of WorldIdentifier[%s]", WorldIdentifierImpl.asString(namespace, value)));
        }
        if (WorldIdentifierImpl.fails(VALUE_PREDICATE, value)) {
            throw new IllegalArgumentException(String.format("Non [a-z0-9/._-] character in value of WorldIdentifier[%s]", WorldIdentifierImpl.asString(namespace, value)));
        }
        this.namespace = namespace;
        this.value = value;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorldIdentifierImpl that = (WorldIdentifierImpl)o;
        return this.namespace.equals(that.namespace) && this.value.equals(that.value);
    }

    public String toString() {
        return "WorldIdentifierImpl[" + this.asString() + ']';
    }

    @Override
    public String asString() {
        return WorldIdentifierImpl.asString(this.namespace, this.value);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.value);
    }

    private static String asString(String namespace, String value) {
        return namespace + ':' + value;
    }

    private static boolean fails(IntPredicate test, @NonNull String key) {
        int length = key.length();
        for (int i = 0; i < length; ++i) {
            if (test.test(key.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

