/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.LayerProvider;
import xyz.jpenilla.squaremap.api.marker.Marker;

public final class SimpleLayerProvider
implements LayerProvider {
    private final Supplier<String> labelSupplier;
    private final Map<Key, Marker> markers = new ConcurrentHashMap<Key, Marker>();
    private final boolean defaultHidden;
    private final boolean showControls;
    private final int layerPriority;
    private final int zIndex;

    private SimpleLayerProvider(@NonNull Supplier<String> labelSupplier, boolean defaultHidden, boolean showControls, int layerPriority, int zIndex) {
        this.labelSupplier = labelSupplier;
        this.defaultHidden = defaultHidden;
        this.showControls = showControls;
        this.layerPriority = layerPriority;
        this.zIndex = zIndex;
    }

    public static @NonNull Builder builder(@NonNull String label) {
        return new Builder(() -> label);
    }

    public static @NonNull Builder builder(@NonNull Supplier<String> labelSupplier) {
        return new Builder(labelSupplier);
    }

    public void addMarker(@NonNull Key key, @NonNull Marker marker) {
        this.markers.put(key, marker);
    }

    public @Nullable Marker removeMarker(@NonNull Key key) {
        return this.markers.remove(key);
    }

    public void clearMarkers() {
        this.markers.clear();
    }

    public @NonNull Map<Key, Marker> registeredMarkers() {
        return Collections.unmodifiableMap(this.markers);
    }

    public boolean hasMarker(@NonNull Key key) {
        return this.markers.containsKey(key);
    }

    @Override
    public @NonNull String getLabel() {
        return this.labelSupplier.get();
    }

    @Override
    public boolean showControls() {
        return this.showControls;
    }

    @Override
    public boolean defaultHidden() {
        return this.defaultHidden;
    }

    @Override
    public int layerPriority() {
        return this.layerPriority;
    }

    @Override
    public int zIndex() {
        return this.zIndex;
    }

    @Override
    public @NonNull Collection<Marker> getMarkers() {
        return this.markers.values();
    }

    public static final class Builder {
        private final Supplier<String> labelSupplier;
        private boolean defaultHidden = false;
        private boolean showControls = true;
        private int layerPriority = 99;
        private int zIndex = 99;

        private Builder(@NonNull Supplier<String> labelSupplier) {
            this.labelSupplier = labelSupplier;
        }

        public @NonNull Builder defaultHidden(boolean defaultHidden) {
            this.defaultHidden = defaultHidden;
            return this;
        }

        public @NonNull Builder showControls(boolean showControls) {
            this.showControls = showControls;
            return this;
        }

        public @NonNull Builder layerPriority(int layerPriority) {
            this.layerPriority = layerPriority;
            return this;
        }

        public @NonNull Builder zIndex(int zIndex) {
            this.zIndex = zIndex;
            return this;
        }

        public @NonNull SimpleLayerProvider build() {
            return new SimpleLayerProvider(this.labelSupplier, this.defaultHidden, this.showControls, this.layerPriority, this.zIndex);
        }
    }
}

