/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas;

import com.klaytn.caver.Caver;
import com.klaytn.caver.wallet.IWallet;
import com.squareup.okhttp.Credentials;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketService;
import xyz.groundx.caver_ext_kas.ConfigOptions;
import xyz.groundx.caver_ext_kas.kas.KAS;
import xyz.groundx.caver_ext_kas.wallet.KASWallet;

public class CaverExtKAS
extends Caver {
    private static final String URL_NODE_API = "https://node-api.klaytnapi.com/v1/klaytn";
    private static final String URL_ANCHOR_API = "https://anchor-api.klaytnapi.com";
    private static final String URL_TH_API = "https://th-api.klaytnapi.com";
    private static final String URL_WALLET_API = "https://wallet-api.klaytnapi.com";
    private static final String URL_KIP17_API = "https://kip17-api.klaytnapi.com";
    private static final String URL_KIP7_API = "https://kip7-api.klaytnapi.com";
    private static final String URL_KIP37_API = "https://kip37-api.klaytnapi.com";
    public static final String CHAIN_ID_BAOBOB = "1001";
    public static final String CHAIN_ID_CYPRESS = "8217";
    public KAS kas = new KAS();
    public KASWallet wallet;
    private boolean nodeAPIInitialized;

    public CaverExtKAS() {
    }

    public CaverExtKAS(int chainId, String accessKeyId, String secretAccessKey) {
        this();
        this.initKASAPI(chainId, accessKeyId, secretAccessKey);
    }

    public CaverExtKAS(String chainId, String accessKeyId, String secretAccessKey) {
        this();
        this.initKASAPI(chainId, accessKeyId, secretAccessKey);
    }

    public CaverExtKAS(int chainId, String accessKeyId, String secretAccessKey, ConfigOptions options) {
        this();
        this.initKASAPI(chainId, accessKeyId, secretAccessKey, options);
    }

    public CaverExtKAS(String chainId, String accessKeyId, String secretAccessKey, ConfigOptions options) {
        this();
        this.initKASAPI(chainId, accessKeyId, secretAccessKey, options);
    }

    public void initKASAPI(int chainId, String accessKeyId, String secretAccessKey) {
        ConfigOptions options = new ConfigOptions();
        options.setUseNodeAPIWithHttp(true);
        this.initKASAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, options);
    }

    public void initKASAPI(String chainId, String accessKeyId, String secretAccessKey) {
        ConfigOptions options = new ConfigOptions();
        options.setUseNodeAPIWithHttp(true);
        this.initKASAPI(chainId, accessKeyId, secretAccessKey, options);
    }

    public void initKASAPI(int chainId, String accessKeyId, String secretAccessKey, ConfigOptions options) {
        this.initKASAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, options);
    }

    public void initKASAPI(String chainId, String accessKeyId, String secretAccessKey, ConfigOptions options) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, options.getUseNodeAPIWithHttp());
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey);
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey);
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey);
        this.initKIP17API(chainId, accessKeyId, secretAccessKey);
        this.initKIP7API(chainId, accessKeyId, secretAccessKey);
        this.initKIP37API(chainId, accessKeyId, secretAccessKey);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey, boolean useNodeAPIWithHttp) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API, useNodeAPIWithHttp);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey, boolean useNodeAPIWithHttp) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, URL_NODE_API, useNodeAPIWithHttp);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, url, true);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initNodeAPI(chainId, accessKeyId, secretAccessKey, url, true);
    }

    public void initNodeAPI(int chainId, String accessKeyId, String secretAccessKey, String url, boolean useNodeAPIWithHttp) {
        this.initNodeAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url, useNodeAPIWithHttp);
    }

    public void initNodeAPI(String chainId, String accessKeyId, String secretAccessKey, String url, boolean useNodeAPIWithHttp) {
        if (useNodeAPIWithHttp) {
            this.initNodeAPIWithHttp(chainId, accessKeyId, secretAccessKey, url);
        } else {
            this.initNodeAPIWithWebSocket(chainId, accessKeyId, secretAccessKey, url);
        }
        this.nodeAPIInitialized = true;
        if (this.kas.wallet != null) {
            this.kas.wallet.setNodeAPIInitialized(this.nodeAPIInitialized);
        }
    }

    public void initAnchorAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey, URL_ANCHOR_API);
    }

    public void initAnchorAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initAnchorAPI(chainId, accessKeyId, secretAccessKey, URL_ANCHOR_API);
    }

    public void initAnchorAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initAnchorAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initAnchorAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initAnchorAPI(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initWalletAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey, URL_WALLET_API);
    }

    public void initWalletAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initWalletAPI(chainId, accessKeyId, secretAccessKey, URL_WALLET_API);
    }

    public void initWalletAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initWalletAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initWalletAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initWalletAPI(chainId, accessKeyId, secretAccessKey, url);
        this.kas.wallet.setRPC(this.rpc);
        this.kas.wallet.setNodeAPIInitialized(this.nodeAPIInitialized);
        this.setWallet(new KASWallet(this.kas.wallet));
    }

    public void initTokenHistoryAPI(int chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_TH_API);
    }

    public void initTokenHistoryAPI(String chainId, String accessKeyId, String secretAccessKey) {
        this.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, URL_TH_API);
    }

    public void initTokenHistoryAPI(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initTokenHistoryAPI(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initTokenHistoryAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initTokenHistoryAPI(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initKIP17API(int chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP17API(chainId, accessKeyId, secretAccessKey, URL_KIP17_API);
    }

    public void initKIP17API(String chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP17API(chainId, accessKeyId, secretAccessKey, URL_KIP17_API);
    }

    public void initKIP17API(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initKIP17API(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initKIP17API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initKIP17API(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initKIP7API(int chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP7API(chainId, accessKeyId, secretAccessKey, URL_KIP7_API);
    }

    public void initKIP7API(String chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP7API(chainId, accessKeyId, secretAccessKey, URL_KIP7_API);
    }

    public void initKIP7API(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initKIP7API(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initKIP7API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initKIP7API(chainId, accessKeyId, secretAccessKey, url);
    }

    public void initKIP37API(int chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP37API(chainId, accessKeyId, secretAccessKey, URL_KIP37_API);
    }

    public void initKIP37API(String chainId, String accessKeyId, String secretAccessKey) {
        this.initKIP37API(chainId, accessKeyId, secretAccessKey, URL_KIP37_API);
    }

    public void initKIP37API(int chainId, String accessKeyId, String secretAccessKey, String url) {
        this.initKIP37API(String.valueOf(chainId), accessKeyId, secretAccessKey, url);
    }

    public void initKIP37API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        this.kas.initKIP37API(chainId, accessKeyId, secretAccessKey, url);
    }

    public KAS getKas() {
        return this.kas;
    }

    public void setKas(KAS kas) {
        this.kas = kas;
    }

    public IWallet getWallet() {
        return this.wallet;
    }

    public void setWallet(KASWallet wallet) {
        this.wallet = wallet;
    }

    private void initNodeAPIWithHttp(String chainId, String accessKeyId, String secretAccessKey, String url) {
        if (url.equals("https://node-api.klaytnapi.com")) {
            url = url + "/v1/klaytn";
        }
        HttpService httpService = new HttpService(url);
        httpService.addHeader("Authorization", Credentials.basic((String)accessKeyId, (String)secretAccessKey));
        httpService.addHeader("x-chain-id", chainId);
        this.setCurrentProvider((Web3jService)httpService);
        if (this.kas.wallet != null) {
            this.kas.wallet.setRPC(this.rpc);
        }
    }

    private void initNodeAPIWithWebSocket(String chainId, String accessKeyId, String secretAccessKey, String url) {
        Pattern regexAccessKey = Pattern.compile("^[a-zA-Z0-9]*$");
        Pattern regexSecretAccessKey = Pattern.compile("^[^?=&+\\s]+$");
        if (!regexAccessKey.matcher(accessKeyId).matches() || !regexSecretAccessKey.matcher(secretAccessKey).matches()) {
            throw new InvalidParameterException("Invalid auth: To use the websocket provider, you must use an accessKey and secretAccessKey that do not contain special characters. Please obtain a new AccessKey through the KAS Console.");
        }
        String websocketUrl = url.replace("https", "wss");
        websocketUrl = websocketUrl.replace("v1/klaytn", "v1/ws/open?chain-id=" + chainId);
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Authorization", Credentials.basic((String)accessKeyId, (String)secretAccessKey));
            WebSocketClient webSocketClient = new WebSocketClient(new URI(websocketUrl), header);
            WebSocketService webSocketService = new WebSocketService(webSocketClient, false);
            this.setCurrentProvider((Web3jService)webSocketService);
            if (this.kas.wallet != null) {
                this.kas.wallet.setRPC(this.rpc);
            }
            webSocketService.connect();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to parse URL: '%s'", websocketUrl), e);
        }
        catch (ConnectException e) {
            throw new RuntimeException(String.format("Failed to connect URL: '%s'", websocketUrl), e);
        }
    }
}

