/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP Fee Delegation transaction request schema")
public class FDProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="3555775530180462144262874045285080385370799680061830405427251022536315012269437422034374993063363749301742829272037747644239373485472413527444702067525461969341399272696727992089574644794322321180116327861197303036706490360864473007240629099715093535386713837632516014363102287578039545675062105146793695262293102216573565529608532205222903395261337039873747035896626237362069578385680533152328511336466814096878076481705061972667213454900403580370736470601448426491508233930895755649869405162339251883008775165032123394239040705099716216279402849800838850950981610368235770451912324298036637295955929962482481888191347801633665207860165797597798831519174320276290046107532585800539861694122284697058136492270376156223710454841873933260740276640178212258527217081721693027611243767534321676277060036746843485408399065357740002708000609457236348955491018515453427879081623554506129807136433389945001993592811830189424095074622922985371614243848723931601896292370835976953286803111134307816439219191510955347801300158362176963619324450759962513927697331939202785771534315838313402567190182235326985174084227831310785899670881996541347342978753817173810545435491276918518420567836513660002590106877275897078985714421417586266886157606655819550183329449267631954783889", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only (partial) fee delegation transaction type is allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDProcessRLPRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDProcessRLPRequest fdProcessRLPRequest = (FDProcessRLPRequest)o;
        return Objects.equals(this.rlp, fdProcessRLPRequest.rlp) && Objects.equals(this.submit, fdProcessRLPRequest.submit) && Objects.equals(this.feeRatio, fdProcessRLPRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

