/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.kip37.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MintKip37TokenRequest {
    @SerializedName(value="sender")
    private String sender = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="ids")
    private List<String> ids = new ArrayList<String>();
    @SerializedName(value="amounts")
    private List<String> amounts = new ArrayList<String>();

    public MintKip37TokenRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    @Schema(description="The Klaytn account address to mint tokens. The default value is the address that deployed the contract.")
    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public MintKip37TokenRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(required=true, description="The Klaytn account address of the token owner")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public MintKip37TokenRequest ids(List<String> ids) {
        this.ids = ids;
        return this;
    }

    public MintKip37TokenRequest addIdsItem(String idsItem) {
        this.ids.add(idsItem);
        return this;
    }

    @Schema(required=true, description="Array of the new token IDs")
    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public MintKip37TokenRequest amounts(List<String> amounts) {
        this.amounts = amounts;
        return this;
    }

    public MintKip37TokenRequest addAmountsItem(String amountsItem) {
        this.amounts.add(amountsItem);
        return this;
    }

    @Schema(required=true, description="Array of the new token supplies (in hex.)")
    public List<String> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(List<String> amounts) {
        this.amounts = amounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MintKip37TokenRequest mintKip37TokenRequest = (MintKip37TokenRequest)o;
        return Objects.equals(this.sender, mintKip37TokenRequest.sender) && Objects.equals(this.to, mintKip37TokenRequest.to) && Objects.equals(this.ids, mintKip37TokenRequest.ids) && Objects.equals(this.amounts, mintKip37TokenRequest.amounts);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.to, this.ids, this.amounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MintKip37TokenRequest {\n");
        sb.append("    sender: ").append(this.toIndentedString(this.sender)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    ids: ").append(this.toIndentedString(this.ids)).append("\n");
        sb.append("    amounts: ").append(this.toIndentedString(this.amounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

