/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas;

import xyz.groundx.caver_ext_kas.kas.anchor.Anchor;
import xyz.groundx.caver_ext_kas.kas.kip17.KIP17;
import xyz.groundx.caver_ext_kas.kas.kip7.KIP7;
import xyz.groundx.caver_ext_kas.kas.tokenhistory.TokenHistory;
import xyz.groundx.caver_ext_kas.kas.wallet.Wallet;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.ApiClient;

public class KAS {
    public Anchor anchor;
    public TokenHistory tokenHistory;
    public Wallet wallet;
    public KIP17 kip17;
    public KIP7 kip7;

    public KAS initAnchorAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(url);
        apiClient.setUsername(accessKeyId);
        apiClient.setPassword(secretAccessKey);
        this.setAnchor(new Anchor(chainId, apiClient));
        return this;
    }

    public KAS initWalletAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(url);
        apiClient.setUsername(accessKeyId);
        apiClient.setPassword(secretAccessKey);
        this.setWallet(new Wallet(chainId, apiClient));
        return this;
    }

    public KAS initTokenHistoryAPI(String chainId, String accessKeyId, String secretAccessKey, String url) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(url);
        apiClient.setUsername(accessKeyId);
        apiClient.setPassword(secretAccessKey);
        this.setTokenHistory(new TokenHistory(chainId, apiClient));
        return this;
    }

    public KAS initKIP17API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(url);
        apiClient.setUsername(accessKeyId);
        apiClient.setPassword(secretAccessKey);
        this.setKip17(new KIP17(chainId, apiClient));
        return this;
    }

    public KAS initKIP7API(String chainId, String accessKeyId, String secretAccessKey, String url) {
        ApiClient apiClient = new ApiClient();
        apiClient.setBasePath(url);
        apiClient.setUsername(accessKeyId);
        apiClient.setPassword(secretAccessKey);
        this.setKip7(new KIP7(chainId, apiClient));
        return this;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public TokenHistory getTokenHistory() {
        return this.tokenHistory;
    }

    public void setTokenHistory(TokenHistory tokenHistory) {
        this.tokenHistory = tokenHistory;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public KIP17 getKip17() {
        return this.kip17;
    }

    public void setKip17(KIP17 kip17) {
        this.kip17 = kip17;
    }

    public KIP7 getKip7() {
        return this.kip7;
    }

    public void setKip7(KIP7 kip7) {
        this.kip7 = kip7;
    }
}

