/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="RLP User Fee Delegation transaction request schema")
public class FDUserProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDUserProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0x29f9020a8205a98505d21dba008389544080809460d0902c428d0e197f97a756011fd4893c1e57b0b9013a60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000000000000000000000000000000900463ffffffff16806306661abd14605857806342cbb15c146080578063d14e62b81460a8575b600080fd5b348015606357600080fd5b50606a60d2565b6040518082815260200191505060405180910390f35b348015608b57600080fd5b50609260d8565b6040518082815260200191505060405180910390f35b34801560b357600080fd5b5060d06004803603810190808035906020019092919050505060e0565b005b60005481565b600043905090565b80600081905550505600a165627a7a7230582059344095f4f4ad6d1a407f2f20de3e3e65e8ead0c1aaf64728546db62db6f76f00298080f847f8458207f5a0cd1945938558bfa23807007ebb5032b7f89257af256e2255758c026f6aac2f33a040723c4123312673ef6afec746f5fb43744fac5bc96998d954a43cd27f0947f6940e916319466895015cbcb453a1ff8c4134feb902f847f8458207f5a06ff5ad95e521b7aeb3698043bc570362c07efa42bec1888184380e9ce9577ee4a037466e88813ff38a922709b53c9956246513343a74a78f359f470e09c4a023e9", required=true, description="The Klaytn RLP formats SigRLP or TxHashRLP are accepted as RLP values and only (partial) fee delegation transaction type is allowed.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDUserProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserProcessRLPRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x48C71A602AC5284b9A501457e4340E16D8d40C3d", required=true, description="Account address for user Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserProcessRLPRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserProcessRLPRequest fdUserProcessRLPRequest = (FDUserProcessRLPRequest)o;
        return Objects.equals(this.rlp, fdUserProcessRLPRequest.rlp) && Objects.equals(this.submit, fdUserProcessRLPRequest.submit) && Objects.equals(this.feePayer, fdUserProcessRLPRequest.feePayer) && Objects.equals(this.feeRatio, fdUserProcessRLPRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.feePayer, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

