/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User Fee Delegation contract deploy transaction request schema")
public class FDUserContractDeployTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 900000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDUserContractDeployTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x60d0902c428D0E197F97a756011Fd4893C1E57B0", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDUserContractDeployTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x0", description="KLAY converted into PEB")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FDUserContractDeployTransactionRequest input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x60806040526000805534801561001457600080fd5b50610116806100246000396000f3006080604052600436106053576000357c0100000000000000000000000000000", required=true, description="Data that is sent along with the transaction and is used for execution.")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDUserContractDeployTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDUserContractDeployTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value)")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDUserContractDeployTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDUserContractDeployTransactionRequest feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x48C71A602AC5284b9A501457e4340E16D8d40C3d", required=true, description="Account address for user Fee Delegation")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDUserContractDeployTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDUserContractDeployTransactionRequest fdUserContractDeployTransactionRequest = (FDUserContractDeployTransactionRequest)o;
        return Objects.equals(this.from, fdUserContractDeployTransactionRequest.from) && Objects.equals(this.value, fdUserContractDeployTransactionRequest.value) && Objects.equals(this.input, fdUserContractDeployTransactionRequest.input) && Objects.equals(this.nonce, fdUserContractDeployTransactionRequest.nonce) && Objects.equals(this.gas, fdUserContractDeployTransactionRequest.gas) && Objects.equals(this.submit, fdUserContractDeployTransactionRequest.submit) && Objects.equals(this.feePayer, fdUserContractDeployTransactionRequest.feePayer) && Objects.equals(this.feeRatio, fdUserContractDeployTransactionRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.input, this.nonce, this.gas, this.submit, this.feePayer, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDUserContractDeployTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

