/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.AccountUpdateKey;

@Schema(description="Fee Payer account update transaction request schema")
public class FDAccountUpdateTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="accountKey")
    private AccountUpdateKey accountKey = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;

    public FDAccountUpdateTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0xAE221779273867b9b9a17fF128D8a326622C8D8a", required=true, description="Klaytn transaction address to send transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDAccountUpdateTransactionRequest accountKey(AccountUpdateKey accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(description="")
    public AccountUpdateKey getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(AccountUpdateKey accountKey) {
        this.accountKey = accountKey;
    }

    public FDAccountUpdateTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique identifier for the transactions being sent (By entering 0, the nonce will be automatically determined)")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDAccountUpdateTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0", description="Maximum gas fee to be used for sending the transaction (By entering 0, it will be set to default value)")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDAccountUpdateTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Shows whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public FDAccountUpdateTransactionRequest feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="20", description="The ratio of the gas fee to be delegated. When it's empty or 0, the entire fee will be delegated.")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDAccountUpdateTransactionRequest fdAccountUpdateTransactionRequest = (FDAccountUpdateTransactionRequest)o;
        return Objects.equals(this.from, fdAccountUpdateTransactionRequest.from) && Objects.equals(this.accountKey, fdAccountUpdateTransactionRequest.accountKey) && Objects.equals(this.nonce, fdAccountUpdateTransactionRequest.nonce) && Objects.equals(this.gas, fdAccountUpdateTransactionRequest.gas) && Objects.equals(this.submit, fdAccountUpdateTransactionRequest.submit) && Objects.equals(this.feeRatio, fdAccountUpdateTransactionRequest.feeRatio);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.accountKey, this.nonce, this.gas, this.submit, this.feeRatio);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDAccountUpdateTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

