/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.wallet.migration;

import java.math.BigInteger;
import java.util.List;
import org.web3j.utils.Numeric;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.MigrationAccountKey;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.MultisigPrivateKeys;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.RoleBasedPrivateKeys;
import xyz.groundx.caver_ext_kas.kas.wallet.migration.SinglePrivateKey;

public class MigrationAccount {
    private String address;
    private String nonce = "0x";
    private MigrationAccountKey<?> migrationAccountKey = null;

    public MigrationAccount(String address, String singlePrivateKey) {
        this(address, singlePrivateKey, "0x");
    }

    public MigrationAccount(String address, String[] multisigPrivateKeys) {
        this(address, multisigPrivateKeys, "0x");
    }

    public MigrationAccount(String address, List<String[]> roleBasedPrivateKeys) {
        this(address, roleBasedPrivateKeys, "0x");
    }

    public MigrationAccount(String address, String singlePrivateKey, String nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new SinglePrivateKey(singlePrivateKey));
        this.setNonce(nonce);
    }

    public MigrationAccount(String address, String singlePrivateKey, BigInteger nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new SinglePrivateKey(singlePrivateKey));
        this.setNonce(nonce);
    }

    public MigrationAccount(String address, String[] multisigPrivateKeys, String nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new MultisigPrivateKeys(multisigPrivateKeys));
        this.setNonce(nonce);
    }

    public MigrationAccount(String address, String[] multisigPrivateKeys, BigInteger nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new MultisigPrivateKeys(multisigPrivateKeys));
        this.setNonce(nonce);
    }

    public MigrationAccount(String address, List<String[]> roleBasedPrivateKeys, String nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new RoleBasedPrivateKeys(roleBasedPrivateKeys));
        this.setNonce(nonce);
    }

    public MigrationAccount(String address, List<String[]> roleBasedPrivateKeys, BigInteger nonce) {
        this.setAddress(address);
        this.setMigrationAccountKey(new RoleBasedPrivateKeys(roleBasedPrivateKeys));
        this.setNonce(nonce);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.setNonce(Numeric.toHexStringWithPrefix((BigInteger)nonce));
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public MigrationAccountKey<?> getMigrationAccountKey() {
        return this.migrationAccountKey;
    }

    public void setMigrationAccountKey(MigrationAccountKey<?> key) {
        this.migrationAccountKey = key;
    }
}

