/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Transaction request schema using RLP")
public class ProcessRLPRequest {
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="submit")
    private Boolean submit = null;
    @SerializedName(value="from")
    private String from = null;

    public ProcessRLPRequest rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(required=true, description="The RLP value is used to receive a Klaytn RLP format (SigRLP or TxHashRLP). This scheme just allow legacy and basic transaction type.")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public ProcessRLPRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public ProcessRLPRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", description="")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessRLPRequest processRLPRequest = (ProcessRLPRequest)o;
        return Objects.equals(this.rlp, processRLPRequest.rlp) && Objects.equals(this.submit, processRLPRequest.submit) && Objects.equals(this.from, processRLPRequest.from);
    }

    public int hashCode() {
        return Objects.hash(this.rlp, this.submit, this.from);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessRLPRequest {\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

