/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.ContractCallData;

@Schema(description="Contract Call Request Scheme")
public class ContractCallRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="data")
    private ContractCallData data = null;
    @SerializedName(value="gas")
    private Long gas = null;

    public ContractCallRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ContractCallRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x0", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ContractCallRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0x358b2381fcf00d2cb2daa7d89032b12e140b6058", description="Contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ContractCallRequest data(ContractCallData data) {
        this.data = data;
        return this;
    }

    @Schema(description="")
    public ContractCallData getData() {
        return this.data;
    }

    public void setData(ContractCallData data) {
        this.data = data;
    }

    public ContractCallRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractCallRequest contractCallRequest = (ContractCallRequest)o;
        return Objects.equals(this.from, contractCallRequest.from) && Objects.equals(this.value, contractCallRequest.value) && Objects.equals(this.to, contractCallRequest.to) && Objects.equals(this.data, contractCallRequest.data) && Objects.equals(this.gas, contractCallRequest.gas);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.to, this.data, this.gas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractCallRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

