/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="KLAY Transfer Transaction Request Scheme")
public class ValueTransferTransactionRequest {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="memo")
    private String memo = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="gas")
    private Long gas = 100000L;
    @SerializedName(value="submit")
    private Boolean submit = null;

    public ValueTransferTransactionRequest from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x5bb85d4032354E88020595AFAFC081C24098202e", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ValueTransferTransactionRequest value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x100", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ValueTransferTransactionRequest to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0x2F87Ba64de5526F7880F21481Effbf950f70005c", description="Klaytn account address to receive KLAY")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ValueTransferTransactionRequest memo(String memo) {
        this.memo = memo;
        return this;
    }

    @Schema(example="memo", description="Memo attached to the transaction")
    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public ValueTransferTransactionRequest nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", description="Unique value of the outgoing transaction")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public ValueTransferTransactionRequest gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public ValueTransferTransactionRequest submit(Boolean submit) {
        this.submit = submit;
        return this;
    }

    @Schema(example="true", description="Whether to send the transaction to Klaytn")
    public Boolean isSubmit() {
        return this.submit;
    }

    public void setSubmit(Boolean submit) {
        this.submit = submit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueTransferTransactionRequest valueTransferTransactionRequest = (ValueTransferTransactionRequest)o;
        return Objects.equals(this.from, valueTransferTransactionRequest.from) && Objects.equals(this.value, valueTransferTransactionRequest.value) && Objects.equals(this.to, valueTransferTransactionRequest.to) && Objects.equals(this.memo, valueTransferTransactionRequest.memo) && Objects.equals(this.nonce, valueTransferTransactionRequest.nonce) && Objects.equals(this.gas, valueTransferTransactionRequest.gas) && Objects.equals(this.submit, valueTransferTransactionRequest.submit);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.value, this.to, this.memo, this.nonce, this.gas, this.submit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValueTransferTransactionRequest {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    memo: ").append(this.toIndentedString(this.memo)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    submit: ").append(this.toIndentedString(this.submit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

