/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.EventLog;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.FeePayerSignaturesObj;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Transaction receipt")
public class TransactionReceipt {
    @SerializedName(value="blockHash")
    private String blockHash = null;
    @SerializedName(value="blockNumber")
    private String blockNumber = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private String gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="gasUsed")
    private String gasUsed = null;
    @SerializedName(value="hash")
    private String hash = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="logs")
    private List<EventLog> logs = null;
    @SerializedName(value="logsBloom")
    private String logsBloom = null;
    @SerializedName(value="nonce")
    private String nonce = null;
    @SerializedName(value="senderTxHash")
    private String senderTxHash = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="transactionIndex")
    private String transactionIndex = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="contractAddress")
    private String contractAddress = null;
    @SerializedName(value="codeFormat")
    private String codeFormat = null;
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feePayerSignatures")
    private List<FeePayerSignaturesObj> feePayerSignatures = null;
    @SerializedName(value="humanReadable")
    private Boolean humanReadable = null;

    public TransactionReceipt blockHash(String blockHash) {
        this.blockHash = blockHash;
        return this;
    }

    @Schema(example="0x276e6efcc01b27c992b0663cc843baebc9dbb167cf0cd7e74808c21c97a74182", description="Hash value of the block where the transaction is located")
    public String getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public TransactionReceipt blockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
        return this;
    }

    @Schema(example="0x24bb088", description="No. of the block where the transaction is located")
    public String getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(String blockNumber) {
        this.blockNumber = blockNumber;
    }

    public TransactionReceipt from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x3e3733b256c93f9d759e33c9939258068bd5957d", description="Klaytn account address that sent a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransactionReceipt gas(String gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="0xf4240", description="Max. transaction fee (gas) for sending the transaction")
    public String getGas() {
        return this.gas;
    }

    public void setGas(String gas) {
        this.gas = gas;
    }

    public TransactionReceipt gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="0x5d21dba00", description="Transaction fee (gas) for sending the transaction")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TransactionReceipt gasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    @Schema(example="0x55478", description="Transaction fee (gas) for sending the transaction")
    public String getGasUsed() {
        return this.gasUsed;
    }

    public void setGasUsed(String gasUsed) {
        this.gasUsed = gasUsed;
    }

    public TransactionReceipt hash(String hash) {
        this.hash = hash;
        return this;
    }

    @Schema(example="0x6a3bb7c14981f04e54261a542f0acaf27433befa9619443139f288b3b07c6b05", description="Transaction data hash")
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public TransactionReceipt input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x4867ba1500000000000000000000000000000000000000000000000000000000000000c000000000000000000000000001021e96a79de1b663753935ac856c2cfc51ce8c000000000000000000000000270f21fbf544e5f87b4988c521315a87ce24acf200000000000000000000000000000000000000000000000000000000000000009dbb36061e9a8cb752a9e8abd17e459d7577eaf614f351dfac0b3b3a2d4fca7400000000000000000000000000000000000000000000000000000000000001400000000000000000000000000000000000000000000000000000000000000041efc087a54f954b416b6d051775770336f26d65442306145f8148ee2d2181012d5d49e2d3bd51b22456bb69f5adda7e21c93750aa0c4bfd8a99e6bd17584d10a41b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a401db711901000000000000000000000000000000000000000000000000000000000000000000000000000000000000001c8c7395e3e64e69471ed11debbff2a0ffb89d5b00000000000000000000000000000000000000000000000000000000000000600000000000000000000000000000000000000000000000000000000000000020efefefefefefef0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000", description="Data attached to and used for executing the outgoing transaction")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TransactionReceipt logs(List<EventLog> logs) {
        this.logs = logs;
        return this;
    }

    public TransactionReceipt addLogsItem(EventLog logsItem) {
        if (this.logs == null) {
            this.logs = new ArrayList<EventLog>();
        }
        this.logs.add(logsItem);
        return this;
    }

    @Schema(description="")
    public List<EventLog> getLogs() {
        return this.logs;
    }

    public void setLogs(List<EventLog> logs) {
        this.logs = logs;
    }

    public TransactionReceipt logsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
        return this;
    }

    @Schema(example="0x00000000000000000000000000000000000000000040000000000000200000000000000000000000000001000000000000000000000200000000000000000000000000000000000000000000000000000000000000000004000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000002000000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000800000000000000000000000000000000000080000000000000000000000000000000000000000000800000000000800000000", description="Bloom filter for finding related logs quickly")
    public String getLogsBloom() {
        return this.logsBloom;
    }

    public void setLogsBloom(String logsBloom) {
        this.logsBloom = logsBloom;
    }

    public TransactionReceipt nonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0x26dc3", description="No. of current user\u2019s previous transactions")
    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public TransactionReceipt senderTxHash(String senderTxHash) {
        this.senderTxHash = senderTxHash;
        return this;
    }

    @Schema(example="0x6a3bb7c14981f04e54261a542f0acaf27433befa9619443139f288b3b07c6b05", description="Hash value of a transaction with no fee delegation account and signature value")
    public String getSenderTxHash() {
        return this.senderTxHash;
    }

    public void setSenderTxHash(String senderTxHash) {
        this.senderTxHash = senderTxHash;
    }

    public TransactionReceipt signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public TransactionReceipt addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public TransactionReceipt status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Committed", description="Transaction status. The status is \u201cPending\u201d if the transaction is still in txpool, \u201cCommitted\u201d if the transaction is successful, and \u201cCommitError\u201d if the transaction failed.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionReceipt to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0x01021e96a79de1b663753935ac856c2cfc51ce8c", description="Klaytn account address to receive KLAY or contract address")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransactionReceipt transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0x6a3bb7c14981f04e54261a542f0acaf27433befa9619443139f288b3b07c6b05", description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public TransactionReceipt transactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
        return this;
    }

    @Schema(example="0x0", description="Order of transactions in the block where they are located")
    public String getTransactionIndex() {
        return this.transactionIndex;
    }

    public void setTransactionIndex(String transactionIndex) {
        this.transactionIndex = transactionIndex;
    }

    public TransactionReceipt type(String type) {
        this.type = type;
        return this;
    }

    @Schema(example="TxTypeSmartContractExecution", description="Character value of transaction type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public TransactionReceipt typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="48", description="Numeric value of transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TransactionReceipt value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x0", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransactionReceipt contractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
        return this;
    }

    @Schema(required=true, description="Contract address. It has a null value if it is not for a contract release.")
    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public TransactionReceipt codeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
        return this;
    }

    @Schema(example="0x0", description="Code format of smart contract")
    public String getCodeFormat() {
        return this.codeFormat;
    }

    public void setCodeFormat(String codeFormat) {
        this.codeFormat = codeFormat;
    }

    public TransactionReceipt feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x85b98485444c89880cd9c48807cef727c296f2da", description="Account address for fee delegation of transaction fee")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public TransactionReceipt feePayerSignatures(List<FeePayerSignaturesObj> feePayerSignatures) {
        this.feePayerSignatures = feePayerSignatures;
        return this;
    }

    public TransactionReceipt addFeePayerSignaturesItem(FeePayerSignaturesObj feePayerSignaturesItem) {
        if (this.feePayerSignatures == null) {
            this.feePayerSignatures = new ArrayList<FeePayerSignaturesObj>();
        }
        this.feePayerSignatures.add(feePayerSignaturesItem);
        return this;
    }

    @Schema(description="")
    public List<FeePayerSignaturesObj> getFeePayerSignatures() {
        return this.feePayerSignatures;
    }

    public void setFeePayerSignatures(List<FeePayerSignaturesObj> feePayerSignatures) {
        this.feePayerSignatures = feePayerSignatures;
    }

    public TransactionReceipt humanReadable(Boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    @Schema(example="false", description="Wheter to be `humanReadable` of the account")
    public Boolean isHumanReadable() {
        return this.humanReadable;
    }

    public void setHumanReadable(Boolean humanReadable) {
        this.humanReadable = humanReadable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionReceipt transactionReceipt = (TransactionReceipt)o;
        return Objects.equals(this.blockHash, transactionReceipt.blockHash) && Objects.equals(this.blockNumber, transactionReceipt.blockNumber) && Objects.equals(this.from, transactionReceipt.from) && Objects.equals(this.gas, transactionReceipt.gas) && Objects.equals(this.gasPrice, transactionReceipt.gasPrice) && Objects.equals(this.gasUsed, transactionReceipt.gasUsed) && Objects.equals(this.hash, transactionReceipt.hash) && Objects.equals(this.input, transactionReceipt.input) && Objects.equals(this.logs, transactionReceipt.logs) && Objects.equals(this.logsBloom, transactionReceipt.logsBloom) && Objects.equals(this.nonce, transactionReceipt.nonce) && Objects.equals(this.senderTxHash, transactionReceipt.senderTxHash) && Objects.equals(this.signatures, transactionReceipt.signatures) && Objects.equals(this.status, transactionReceipt.status) && Objects.equals(this.to, transactionReceipt.to) && Objects.equals(this.transactionHash, transactionReceipt.transactionHash) && Objects.equals(this.transactionIndex, transactionReceipt.transactionIndex) && Objects.equals(this.type, transactionReceipt.type) && Objects.equals(this.typeInt, transactionReceipt.typeInt) && Objects.equals(this.value, transactionReceipt.value) && Objects.equals(this.contractAddress, transactionReceipt.contractAddress) && Objects.equals(this.codeFormat, transactionReceipt.codeFormat) && Objects.equals(this.feePayer, transactionReceipt.feePayer) && Objects.equals(this.feePayerSignatures, transactionReceipt.feePayerSignatures) && Objects.equals(this.humanReadable, transactionReceipt.humanReadable);
    }

    public int hashCode() {
        return Objects.hash(this.blockHash, this.blockNumber, this.from, this.gas, this.gasPrice, this.gasUsed, this.hash, this.input, this.logs, this.logsBloom, this.nonce, this.senderTxHash, this.signatures, this.status, this.to, this.transactionHash, this.transactionIndex, this.type, this.typeInt, this.value, this.contractAddress, this.codeFormat, this.feePayer, this.feePayerSignatures, this.humanReadable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionReceipt {\n");
        sb.append("    blockHash: ").append(this.toIndentedString(this.blockHash)).append("\n");
        sb.append("    blockNumber: ").append(this.toIndentedString(this.blockNumber)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    gasUsed: ").append(this.toIndentedString(this.gasUsed)).append("\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    logs: ").append(this.toIndentedString(this.logs)).append("\n");
        sb.append("    logsBloom: ").append(this.toIndentedString(this.logsBloom)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    senderTxHash: ").append(this.toIndentedString(this.senderTxHash)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    transactionIndex: ").append(this.toIndentedString(this.transactionIndex)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    contractAddress: ").append(this.toIndentedString(this.contractAddress)).append("\n");
        sb.append("    codeFormat: ").append(this.toIndentedString(this.codeFormat)).append("\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feePayerSignatures: ").append(this.toIndentedString(this.feePayerSignatures)).append("\n");
        sb.append("    humanReadable: ").append(this.toIndentedString(this.humanReadable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

