/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.render;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videoplayer.player.AbstractPlayer;
import xyz.doikki.videoplayer.render.IRenderView;
import xyz.doikki.videoplayer.render.MeasureHelper;

@SuppressLint(value={"ViewConstructor"})
public class TextureRenderView
extends TextureView
implements IRenderView,
TextureView.SurfaceTextureListener {
    private final MeasureHelper mMeasureHelper = new MeasureHelper();
    private SurfaceTexture mSurfaceTexture;
    @Nullable
    private AbstractPlayer mMediaPlayer;
    private Surface mSurface;

    public TextureRenderView(Context context) {
        super(context);
        this.setSurfaceTextureListener(this);
    }

    @Override
    public void attachToPlayer(@NonNull AbstractPlayer player) {
        this.mMediaPlayer = player;
    }

    @Override
    public void setVideoSize(int videoWidth, int videoHeight) {
        if (videoWidth > 0 && videoHeight > 0) {
            this.mMeasureHelper.setVideoSize(videoWidth, videoHeight);
            this.requestLayout();
        }
    }

    @Override
    public void setVideoRotation(int degree) {
        this.mMeasureHelper.setVideoRotation(degree);
        this.setRotation(degree);
    }

    @Override
    public void setScaleType(int scaleType) {
        this.mMeasureHelper.setScreenScale(scaleType);
        this.requestLayout();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public Bitmap doScreenShot() {
        return this.getBitmap();
    }

    @Override
    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int[] measuredSize = this.mMeasureHelper.doMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(measuredSize[0], measuredSize[1]);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.mSurfaceTexture != null) {
            this.setSurfaceTexture(this.mSurfaceTexture);
        } else {
            this.mSurfaceTexture = surfaceTexture;
            this.mSurface = new Surface(surfaceTexture);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setSurface(this.mSurface);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }
}

