/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.controller;

import android.content.Context;
import android.view.OrientationEventListener;

public class OrientationHelper
extends OrientationEventListener {
    private long mLastTime;
    private OnOrientationChangeListener mOnOrientationChangeListener;

    public OrientationHelper(Context context) {
        super(context);
    }

    public void onOrientationChanged(int orientation) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastTime < 300L) {
            return;
        }
        if (this.mOnOrientationChangeListener != null) {
            this.mOnOrientationChangeListener.onOrientationChanged(orientation);
        }
        this.mLastTime = currentTime;
    }

    public void setOnOrientationChangeListener(OnOrientationChangeListener onOrientationChangeListener) {
        this.mOnOrientationChangeListener = onOrientationChangeListener;
    }

    public static interface OnOrientationChangeListener {
        public void onOrientationChanged(int var1);
    }
}

