/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.controller;

import android.app.Activity;
import android.content.Context;
import android.media.AudioManager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dueeeke.videoplayer.controller.BaseVideoController;
import com.dueeeke.videoplayer.controller.IControlComponent;
import com.dueeeke.videoplayer.controller.IGestureComponent;
import com.dueeeke.videoplayer.util.PlayerUtils;
import java.util.Map;

public abstract class GestureVideoController
extends BaseVideoController
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
View.OnTouchListener {
    private GestureDetector mGestureDetector;
    private AudioManager mAudioManager;
    private boolean mIsGestureEnabled = true;
    private int mStreamVolume;
    private float mBrightness;
    private int mSeekPosition;
    private boolean mFirstTouch;
    private boolean mChangePosition;
    private boolean mChangeBrightness;
    private boolean mChangeVolume;
    private boolean mCanChangePosition = true;
    private boolean mEnableInNormal;
    private boolean mCanSlide;
    private int mCurPlayState;

    public GestureVideoController(@NonNull Context context) {
        super(context);
    }

    public GestureVideoController(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public GestureVideoController(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void initView() {
        super.initView();
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.setOnTouchListener(this);
    }

    public void setCanChangePosition(boolean canChangePosition) {
        this.mCanChangePosition = canChangePosition;
    }

    public void setEnableInNormal(boolean enableInNormal) {
        this.mEnableInNormal = enableInNormal;
    }

    public void setGestureEnabled(boolean gestureEnabled) {
        this.mIsGestureEnabled = gestureEnabled;
    }

    @Override
    public void setPlayerState(int playerState) {
        super.setPlayerState(playerState);
        if (playerState == 10) {
            this.mCanSlide = this.mEnableInNormal;
        } else if (playerState == 11) {
            this.mCanSlide = true;
        }
    }

    @Override
    public void setPlayState(int playState) {
        super.setPlayState(playState);
        this.mCurPlayState = playState;
    }

    private boolean isInPlaybackState() {
        return this.mControlWrapper != null && this.mCurPlayState != -1 && this.mCurPlayState != 0 && this.mCurPlayState != 1 && this.mCurPlayState != 2 && this.mCurPlayState != 8 && this.mCurPlayState != 5;
    }

    public boolean onTouch(View v, MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent e) {
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || PlayerUtils.isEdge(this.getContext(), e)) {
            return true;
        }
        this.mStreamVolume = this.mAudioManager.getStreamVolume(3);
        Activity activity = PlayerUtils.scanForActivity(this.getContext());
        this.mBrightness = activity == null ? 0.0f : activity.getWindow().getAttributes().screenBrightness;
        this.mFirstTouch = true;
        this.mChangePosition = false;
        this.mChangeBrightness = false;
        this.mChangeVolume = false;
        return true;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.isInPlaybackState()) {
            this.mControlWrapper.toggleShowState();
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (!this.isLocked() && this.isInPlaybackState()) {
            this.togglePlay();
        }
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.isInPlaybackState() || !this.mIsGestureEnabled || !this.mCanSlide || this.isLocked() || PlayerUtils.isEdge(this.getContext(), e1)) {
            return true;
        }
        float deltaX = e1.getX() - e2.getX();
        float deltaY = e1.getY() - e2.getY();
        if (this.mFirstTouch) {
            boolean bl = this.mChangePosition = Math.abs(distanceX) >= Math.abs(distanceY);
            if (!this.mChangePosition) {
                int halfScreen = PlayerUtils.getScreenWidth(this.getContext(), true) / 2;
                if (e2.getX() > (float)halfScreen) {
                    this.mChangeVolume = true;
                } else {
                    this.mChangeBrightness = true;
                }
            }
            if (this.mChangePosition) {
                this.mChangePosition = this.mCanChangePosition;
            }
            if (this.mChangePosition || this.mChangeBrightness || this.mChangeVolume) {
                for (Map.Entry next : this.mControlComponents.entrySet()) {
                    IControlComponent component = (IControlComponent)next.getKey();
                    if (!(component instanceof IGestureComponent)) continue;
                    ((IGestureComponent)component).onStartSlide();
                }
            }
            this.mFirstTouch = false;
        }
        if (this.mChangePosition) {
            this.slideToChangePosition(deltaX);
        } else if (this.mChangeBrightness) {
            this.slideToChangeBrightness(deltaY);
        } else if (this.mChangeVolume) {
            this.slideToChangeVolume(deltaY);
        }
        return true;
    }

    protected void slideToChangePosition(float deltaX) {
        deltaX = -deltaX;
        int width = this.getMeasuredWidth();
        int duration = (int)this.mControlWrapper.getDuration();
        int currentPosition = (int)this.mControlWrapper.getCurrentPosition();
        int position = (int)(deltaX / (float)width * 120000.0f + (float)currentPosition);
        if (position > duration) {
            position = duration;
        }
        if (position < 0) {
            position = 0;
        }
        for (Map.Entry next : this.mControlComponents.entrySet()) {
            IControlComponent component = (IControlComponent)next.getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onPositionChange(position, currentPosition, duration);
        }
        this.mSeekPosition = position;
    }

    protected void slideToChangeBrightness(float deltaY) {
        float brightness;
        Activity activity = PlayerUtils.scanForActivity(this.getContext());
        if (activity == null) {
            return;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams attributes = window.getAttributes();
        int height = this.getMeasuredHeight();
        if (this.mBrightness == -1.0f) {
            this.mBrightness = 0.5f;
        }
        if ((brightness = deltaY * 2.0f / (float)height * 1.0f + this.mBrightness) < 0.0f) {
            brightness = 0.0f;
        }
        if (brightness > 1.0f) {
            brightness = 1.0f;
        }
        int percent = (int)(brightness * 100.0f);
        attributes.screenBrightness = brightness;
        window.setAttributes(attributes);
        for (Map.Entry next : this.mControlComponents.entrySet()) {
            IControlComponent component = (IControlComponent)next.getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onBrightnessChange(percent);
        }
    }

    protected void slideToChangeVolume(float deltaY) {
        int streamMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        int height = this.getMeasuredHeight();
        float deltaV = deltaY * 2.0f / (float)height * (float)streamMaxVolume;
        float index = (float)this.mStreamVolume + deltaV;
        if (index > (float)streamMaxVolume) {
            index = streamMaxVolume;
        }
        if (index < 0.0f) {
            index = 0.0f;
        }
        int percent = (int)(index / (float)streamMaxVolume * 100.0f);
        this.mAudioManager.setStreamVolume(3, (int)index, 0);
        for (Map.Entry next : this.mControlComponents.entrySet()) {
            IControlComponent component = (IControlComponent)next.getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onVolumeChange(percent);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mGestureDetector.onTouchEvent(event)) {
            int action = event.getAction();
            switch (action) {
                case 1: {
                    this.stopSlide();
                    if (this.mSeekPosition <= 0) break;
                    this.mControlWrapper.seekTo(this.mSeekPosition);
                    this.mSeekPosition = 0;
                    break;
                }
                case 3: {
                    this.stopSlide();
                    this.mSeekPosition = 0;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private void stopSlide() {
        for (Map.Entry next : this.mControlComponents.entrySet()) {
            IControlComponent component = (IControlComponent)next.getKey();
            if (!(component instanceof IGestureComponent)) continue;
            ((IGestureComponent)component).onStopSlide();
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }
}

