/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.controller;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dueeeke.videoplayer.controller.ControlWrapper;
import com.dueeeke.videoplayer.controller.IControlComponent;
import com.dueeeke.videoplayer.controller.IVideoController;
import com.dueeeke.videoplayer.controller.MediaPlayerControl;
import com.dueeeke.videoplayer.controller.OrientationHelper;
import com.dueeeke.videoplayer.player.VideoViewManager;
import com.dueeeke.videoplayer.util.CutoutUtil;
import com.dueeeke.videoplayer.util.L;
import com.dueeeke.videoplayer.util.PlayerUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class BaseVideoController
extends FrameLayout
implements IVideoController,
OrientationHelper.OnOrientationChangeListener {
    protected ControlWrapper mControlWrapper;
    @Nullable
    protected Activity mActivity;
    protected boolean mShowing;
    protected boolean mIsLocked;
    protected int mDefaultTimeout = 4000;
    private boolean mEnableOrientation;
    protected OrientationHelper mOrientationHelper;
    private boolean mAdaptCutout;
    private Boolean mHasCutout;
    private int mCutoutHeight;
    private boolean mIsStartProgress;
    protected LinkedHashMap<IControlComponent, Boolean> mControlComponents = new LinkedHashMap();
    private Animation mShowAnim;
    private Animation mHideAnim;
    protected final Runnable mFadeOut = new Runnable(){

        @Override
        public void run() {
            BaseVideoController.this.hide();
        }
    };
    protected Runnable mShowProgress = new Runnable(){

        @Override
        public void run() {
            int pos = BaseVideoController.this.setProgress();
            if (BaseVideoController.this.mControlWrapper.isPlaying()) {
                BaseVideoController.this.postDelayed(this, (long)((float)(1000 - pos % 1000) / BaseVideoController.this.mControlWrapper.getSpeed()));
            } else {
                BaseVideoController.this.mIsStartProgress = false;
            }
        }
    };
    private int mOrientation = 0;

    public BaseVideoController(@NonNull Context context) {
        this(context, null);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseVideoController(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    protected void initView() {
        if (this.getLayoutId() != 0) {
            LayoutInflater.from((Context)this.getContext()).inflate(this.getLayoutId(), (ViewGroup)this, true);
        }
        this.mOrientationHelper = new OrientationHelper(this.getContext().getApplicationContext());
        this.mEnableOrientation = VideoViewManager.getConfig().mEnableOrientation;
        this.mAdaptCutout = VideoViewManager.getConfig().mAdaptCutout;
        this.mShowAnim = new AlphaAnimation(0.0f, 1.0f);
        this.mShowAnim.setDuration(300L);
        this.mHideAnim = new AlphaAnimation(1.0f, 0.0f);
        this.mHideAnim.setDuration(300L);
        this.mActivity = PlayerUtils.scanForActivity(this.getContext());
    }

    protected abstract int getLayoutId();

    @CallSuper
    public void setMediaPlayer(MediaPlayerControl mediaPlayer) {
        this.mControlWrapper = new ControlWrapper(mediaPlayer, this);
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            IControlComponent component = next.getKey();
            component.attach(this.mControlWrapper);
        }
        this.mOrientationHelper.setOnOrientationChangeListener(this);
    }

    public void addControlComponent(IControlComponent ... component) {
        for (IControlComponent item : component) {
            this.addControlComponent(item, false);
        }
    }

    public void addControlComponent(IControlComponent component, boolean isPrivate) {
        View view;
        this.mControlComponents.put(component, isPrivate);
        if (this.mControlWrapper != null) {
            component.attach(this.mControlWrapper);
        }
        if ((view = component.getView()) != null && !isPrivate) {
            this.addView(view, 0);
        }
    }

    public void removeControlComponent(IControlComponent component) {
        this.removeView(component.getView());
        this.mControlComponents.remove(component);
    }

    public void removeAllControlComponent() {
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            this.removeView(next.getKey().getView());
        }
        this.mControlComponents.clear();
    }

    public void removeAllPrivateComponents() {
        Iterator<Map.Entry<IControlComponent, Boolean>> it = this.mControlComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IControlComponent, Boolean> next = it.next();
            if (!next.getValue().booleanValue()) continue;
            it.remove();
        }
    }

    @CallSuper
    public void setPlayState(int playState) {
        this.handlePlayStateChanged(playState);
    }

    @CallSuper
    public void setPlayerState(int playerState) {
        this.handlePlayerStateChanged(playerState);
    }

    public void setDismissTimeout(int timeout) {
        if (timeout > 0) {
            this.mDefaultTimeout = timeout;
        }
    }

    @Override
    public void hide() {
        if (this.mShowing) {
            this.stopFadeOut();
            this.handleVisibilityChanged(false, this.mHideAnim);
            this.mShowing = false;
        }
    }

    @Override
    public void show() {
        if (!this.mShowing) {
            this.handleVisibilityChanged(true, this.mShowAnim);
            this.startFadeOut();
            this.mShowing = true;
        }
    }

    @Override
    public boolean isShowing() {
        return this.mShowing;
    }

    @Override
    public void startFadeOut() {
        this.stopFadeOut();
        this.postDelayed(this.mFadeOut, this.mDefaultTimeout);
    }

    @Override
    public void stopFadeOut() {
        this.removeCallbacks(this.mFadeOut);
    }

    @Override
    public void setLocked(boolean locked) {
        this.mIsLocked = locked;
        this.handleLockStateChanged(locked);
    }

    @Override
    public boolean isLocked() {
        return this.mIsLocked;
    }

    @Override
    public void startProgress() {
        if (this.mIsStartProgress) {
            return;
        }
        this.post(this.mShowProgress);
        this.mIsStartProgress = true;
    }

    @Override
    public void stopProgress() {
        if (!this.mIsStartProgress) {
            return;
        }
        this.removeCallbacks(this.mShowProgress);
        this.mIsStartProgress = false;
    }

    private int setProgress() {
        int position = (int)this.mControlWrapper.getCurrentPosition();
        int duration = (int)this.mControlWrapper.getDuration();
        this.handleSetProgress(duration, position);
        return position;
    }

    public void setAdaptCutout(boolean adaptCutout) {
        this.mAdaptCutout = adaptCutout;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.checkCutout();
    }

    private void checkCutout() {
        if (!this.mAdaptCutout) {
            return;
        }
        if (this.mActivity != null && this.mHasCutout == null) {
            this.mHasCutout = CutoutUtil.allowDisplayToCutout(this.mActivity);
            if (this.mHasCutout.booleanValue()) {
                this.mCutoutHeight = (int)PlayerUtils.getStatusBarHeightPortrait((Context)this.mActivity);
            }
        }
        L.d("hasCutout: " + this.mHasCutout + " cutout height: " + this.mCutoutHeight);
    }

    @Override
    public boolean hasCutout() {
        return this.mHasCutout != null && this.mHasCutout != false;
    }

    @Override
    public int getCutoutHeight() {
        return this.mCutoutHeight;
    }

    public boolean showNetWarning() {
        return PlayerUtils.getNetworkType(this.getContext()) == 4 && !VideoViewManager.instance().playOnMobileNetwork();
    }

    protected void togglePlay() {
        this.mControlWrapper.togglePlay();
    }

    protected void toggleFullScreen() {
        this.mControlWrapper.toggleFullScreen(this.mActivity);
    }

    protected boolean startFullScreen() {
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return false;
        }
        this.mActivity.setRequestedOrientation(0);
        this.mControlWrapper.startFullScreen();
        return true;
    }

    protected boolean stopFullScreen() {
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return false;
        }
        this.mActivity.setRequestedOrientation(1);
        this.mControlWrapper.stopFullScreen();
        return true;
    }

    public boolean onBackPressed() {
        return false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mControlWrapper.isPlaying() && (this.mEnableOrientation || this.mControlWrapper.isFullScreen())) {
            if (hasWindowFocus) {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BaseVideoController.this.mOrientationHelper.enable();
                    }
                }, 800L);
            } else {
                this.mOrientationHelper.disable();
            }
        }
    }

    public void setEnableOrientation(boolean enableOrientation) {
        this.mEnableOrientation = enableOrientation;
    }

    @Override
    @CallSuper
    public void onOrientationChanged(int orientation) {
        if (this.mActivity == null || this.mActivity.isFinishing()) {
            return;
        }
        int lastOrientation = this.mOrientation;
        if (orientation == -1) {
            this.mOrientation = -1;
            return;
        }
        if (orientation > 350 || orientation < 10) {
            int o = this.mActivity.getRequestedOrientation();
            if (o == 0 && lastOrientation == 0) {
                return;
            }
            if (this.mOrientation == 0) {
                return;
            }
            this.mOrientation = 0;
            this.onOrientationPortrait(this.mActivity);
        } else if (orientation > 80 && orientation < 100) {
            int o = this.mActivity.getRequestedOrientation();
            if (o == 1 && lastOrientation == 90) {
                return;
            }
            if (this.mOrientation == 90) {
                return;
            }
            this.mOrientation = 90;
            this.onOrientationReverseLandscape(this.mActivity);
        } else if (orientation > 260 && orientation < 280) {
            int o = this.mActivity.getRequestedOrientation();
            if (o == 1 && lastOrientation == 270) {
                return;
            }
            if (this.mOrientation == 270) {
                return;
            }
            this.mOrientation = 270;
            this.onOrientationLandscape(this.mActivity);
        }
    }

    protected void onOrientationPortrait(Activity activity) {
        if (this.mIsLocked) {
            return;
        }
        if (!this.mEnableOrientation) {
            return;
        }
        activity.setRequestedOrientation(1);
        this.mControlWrapper.stopFullScreen();
    }

    protected void onOrientationLandscape(Activity activity) {
        activity.setRequestedOrientation(0);
        if (this.mControlWrapper.isFullScreen()) {
            this.handlePlayerStateChanged(11);
        } else {
            this.mControlWrapper.startFullScreen();
        }
    }

    protected void onOrientationReverseLandscape(Activity activity) {
        activity.setRequestedOrientation(8);
        if (this.mControlWrapper.isFullScreen()) {
            this.handlePlayerStateChanged(11);
        } else {
            this.mControlWrapper.startFullScreen();
        }
    }

    private void handleVisibilityChanged(boolean isVisible, Animation anim) {
        if (!this.mIsLocked) {
            for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
                IControlComponent component = next.getKey();
                component.onVisibilityChanged(isVisible, anim);
            }
        }
        this.onVisibilityChanged(isVisible, anim);
    }

    protected void onVisibilityChanged(boolean isVisible, Animation anim) {
    }

    private void handlePlayStateChanged(int playState) {
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            IControlComponent component = next.getKey();
            component.onPlayStateChanged(playState);
        }
        this.onPlayStateChanged(playState);
    }

    @CallSuper
    protected void onPlayStateChanged(int playState) {
        switch (playState) {
            case 0: {
                this.mOrientationHelper.disable();
                this.mOrientation = 0;
                this.mIsLocked = false;
                this.mShowing = false;
                this.removeAllPrivateComponents();
                break;
            }
            case 5: {
                this.mIsLocked = false;
                this.mShowing = false;
                break;
            }
            case -1: {
                this.mShowing = false;
            }
        }
    }

    private void handlePlayerStateChanged(int playerState) {
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            IControlComponent component = next.getKey();
            component.onPlayerStateChanged(playerState);
        }
        this.onPlayerStateChanged(playerState);
    }

    @CallSuper
    protected void onPlayerStateChanged(int playerState) {
        switch (playerState) {
            case 10: {
                if (this.mEnableOrientation) {
                    this.mOrientationHelper.enable();
                } else {
                    this.mOrientationHelper.disable();
                }
                if (!this.hasCutout()) break;
                CutoutUtil.adaptCutoutAboveAndroidP(this.getContext(), false);
                break;
            }
            case 11: {
                this.mOrientationHelper.enable();
                if (!this.hasCutout()) break;
                CutoutUtil.adaptCutoutAboveAndroidP(this.getContext(), true);
                break;
            }
            case 12: {
                this.mOrientationHelper.disable();
            }
        }
    }

    private void handleSetProgress(int duration, int position) {
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            IControlComponent component = next.getKey();
            component.setProgress(duration, position);
        }
        this.setProgress(duration, position);
    }

    protected void setProgress(int duration, int position) {
    }

    private void handleLockStateChanged(boolean isLocked) {
        for (Map.Entry<IControlComponent, Boolean> next : this.mControlComponents.entrySet()) {
            IControlComponent component = next.getKey();
            component.onLockStateChanged(isLocked);
        }
        this.onLockStateChanged(isLocked);
    }

    protected void onLockStateChanged(boolean isLocked) {
    }
}

