/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.fd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;
import xyz.deftu.fd.ConnectionHelper;
import xyz.deftu.fd.FileDownloadState;
import xyz.deftu.fd.FileDownloader;
import xyz.deftu.fd.FileHelper;
import xyz.deftu.fd.HashingHelper;

class FileDownloaderImpl
implements FileDownloader {
    private boolean caches = true;
    private String userAgent;
    private int timeout = 30000;
    private FileDownloadState state;
    private File tempDir;
    private File existingFile;
    private boolean downloaded;
    private File tempFile;
    private boolean doingValidation;
    private boolean failedValidation;

    FileDownloaderImpl() {
    }

    @Override
    public void initialize(File tempDir, File existingFile) {
        if (this.state != null) {
            throw new IllegalStateException("Cannot initialize file downloader after a state has been set.");
        }
        this.tempDir = tempDir;
        this.existingFile = existingFile;
        this.state = FileDownloadState.INITIALIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String url) {
        if (this.state != FileDownloadState.INITIALIZED) {
            throw new IllegalStateException("Download must take place after initialization");
        }
        HttpURLConnection connection = ConnectionHelper.createConnection(url, this.caches, this.userAgent, this.timeout);
        try (InputStream stream = connection.getInputStream();){
            File tempFile = FileHelper.createTemporaryFile(this.tempDir);
            while (tempFile.exists()) {
                tempFile = FileHelper.createTemporaryFile(this.tempDir);
            }
            if (!tempFile.exists()) {
                tempFile.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            ReadableByteChannel streamChannel = Channels.newChannel(stream);
            while (fileOutputStream.getChannel().transferFrom(streamChannel, 0L, Long.MAX_VALUE) > 0L) {
            }
            this.tempFile = tempFile;
            fileOutputStream.flush();
            fileOutputStream.close();
            streamChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.downloaded = true;
            this.state = FileDownloadState.DOWNLOADED;
        }
    }

    @Override
    public void validate() {
        if (this.state != FileDownloadState.DOWNLOADED) {
            throw new IllegalStateException("Validation must take place after download.");
        }
        this.doingValidation = true;
        this.failedValidation = Objects.equals(HashingHelper.fetchChecksum(this.tempFile), HashingHelper.fetchChecksum(this.existingFile));
        this.state = FileDownloadState.VALIDATED;
    }

    @Override
    public void complete(File newFile) {
        if (this.state == FileDownloadState.DOWNLOADED || this.state == FileDownloadState.VALIDATED) {
            if (!(!this.downloaded || this.doingValidation && this.failedValidation)) {
                if (this.existingFile != null && this.existingFile.exists()) {
                    this.existingFile.delete();
                }
                if (!this.tempFile.renameTo(newFile)) {
                    throw new IllegalStateException("Failed to move downloaded file.");
                }
                this.state = FileDownloadState.COMPLETED;
            } else {
                this.tempFile.delete();
            }
        } else {
            throw new IllegalStateException("Completion must take place after download or validation.");
        }
    }

    @Override
    public FileDownloader withCaches(boolean caches) {
        this.caches = caches;
        return this;
    }

    @Override
    public FileDownloader withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public FileDownloader withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public FileDownloadState getState() {
        return this.state;
    }
}

