/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.tparse.CToken;
import xyz.cofe.text.tparse.CharPointer;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Tok;
import xyz.cofe.text.tparse.TokensIterator;

public class Tokenizer<P extends Pointer<?, ?, P>, T extends Tok<P>>
implements Eterable<T> {
    private final List<GR<P, ? super T>> rules;
    private final P pointer;

    public Tokenizer(P initial, Iterable<GR<P, T>> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("rules==null");
        }
        if (initial == null) {
            throw new IllegalArgumentException("initial==null");
        }
        ArrayList<GR<P, T>> arules = new ArrayList<GR<P, T>>();
        for (GR<P, T> r : rules) {
            if (r == null) {
                throw new IllegalArgumentException("rules contains empty element");
            }
            arules.add(r);
        }
        this.rules = arules;
        this.pointer = initial;
    }

    public TokensIterator<P, T> iterator() {
        return new TokensIterator(this.pointer, this.rules);
    }

    public static Tokenizer<CharPointer, CToken> lexer(String source, Iterable<GR<CharPointer, ? extends CToken>> rules) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (rules == null) {
            throw new IllegalArgumentException("rules == null");
        }
        CharPointer cptr = new CharPointer(source);
        return new Tokenizer<CharPointer, CToken>(cptr, rules);
    }

    public static Tokenizer<CharPointer, CToken> lexer(String source, int from, Iterable<GR<CharPointer, ? extends CToken>> rules) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (rules == null) {
            throw new IllegalArgumentException("rules == null");
        }
        if (from < 0) {
            throw new IllegalArgumentException("from<0");
        }
        CharPointer cptr = new CharPointer(source, from);
        return new Tokenizer<CharPointer, CToken>(cptr, rules);
    }

    public static Tokenizer<CharPointer, ? extends CToken> lexer(String source, GR<CharPointer, ? extends CToken> ... rules) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (rules == null) {
            throw new IllegalArgumentException("rules == null");
        }
        CharPointer cptr = new CharPointer(source);
        return new Tokenizer(cptr, Arrays.asList(rules));
    }

    public static Tokenizer<CharPointer, ? extends CToken> lexer(String source, int from, GR<CharPointer, ? extends CToken> ... rules) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (rules == null) {
            throw new IllegalArgumentException("rules == null");
        }
        if (from < 0) {
            throw new IllegalArgumentException("from<0");
        }
        CharPointer cptr = new CharPointer(source, from);
        return new Tokenizer(cptr, Arrays.asList(rules));
    }
}

