/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.List;
import java.util.Optional;
import xyz.cofe.fn.Fn5;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.ImplementError;
import xyz.cofe.text.tparse.MapResultError;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Sq5OP;
import xyz.cofe.text.tparse.SqNOPImpl;
import xyz.cofe.text.tparse.Tok;

public class Sq5OPImpl<P extends Pointer<?, ?, P>, T1 extends Tok<P>, T2 extends Tok<P>, T3 extends Tok<P>, T4 extends Tok<P>, T5 extends Tok<P>>
implements Sq5OP<P, T1, T2, T3, T4, T5> {
    private final GR<P, T1> first;
    private final GR<P, T2> second;
    private final GR<P, T3> third;
    private final GR<P, T4> fourth;
    private final GR<P, T5> fifth;

    public Sq5OPImpl(GR<P, T1> first, GR<P, T2> second, GR<P, T3> third, GR<P, T4> fourth, GR<P, T5> fifth) {
        if (first == null) {
            throw new IllegalArgumentException("first==null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second==null");
        }
        if (third == null) {
            throw new IllegalArgumentException("third==null");
        }
        if (fourth == null) {
            throw new IllegalArgumentException("fourth==null");
        }
        if (fifth == null) {
            throw new IllegalArgumentException("fifth==null");
        }
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
        this.fifth = fifth;
    }

    @Override
    public <U extends Tok<P>> GR<P, U> map(final Fn5<T1, T2, T3, T4, T5, U> map) {
        if (map == null) {
            throw new IllegalArgumentException("map == null");
        }
        return new GR<P, U>(){
            private String name;
            private final SqNOPImpl<P> sq;
            {
                this.sq = new SqNOPImpl(Sq5OPImpl.this.first, Sq5OPImpl.this.second, Sq5OPImpl.this.third, Sq5OPImpl.this.fourth, Sq5OPImpl.this.fifth);
            }

            @Override
            public GR<P, U> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<U> apply(P ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Optional m = this.sq.name(this.name).match(ptr);
                if (m.isPresent()) {
                    Tok t4;
                    Tok t3;
                    Tok t2;
                    Tok t1;
                    List toks = m.get();
                    if (toks.size() < 5) {
                        throw new ImplementError("tokens count < 5");
                    }
                    Tok t0 = toks.get(0);
                    Tok t = (Tok)map.apply(t0, t1 = toks.get(1), t2 = toks.get(2), t3 = toks.get(3), t4 = toks.get(4));
                    if (t == null) {
                        throw new MapResultError("return null");
                    }
                    if (t.end().position() != t4.end().position()) {
                        throw new MapResultError("pointer order");
                    }
                    return Optional.of(t);
                }
                return Optional.empty();
            }
        };
    }
}

