/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.List;
import java.util.Optional;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.ImplementError;
import xyz.cofe.text.tparse.MapResultError;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.Sq3OP;
import xyz.cofe.text.tparse.Sq4OP;
import xyz.cofe.text.tparse.Sq4OPImpl;
import xyz.cofe.text.tparse.SqNOPImpl;
import xyz.cofe.text.tparse.Tok;

public class Sq3OPImpl<P extends Pointer<?, ?, P>, T1 extends Tok<P>, T2 extends Tok<P>, T3 extends Tok<P>>
implements Sq3OP<P, T1, T2, T3> {
    private final GR<P, T1> first;
    private final GR<P, T2> second;
    private final GR<P, T3> third;

    public Sq3OPImpl(GR<P, T1> first, GR<P, T2> second, GR<P, T3> third) {
        if (first == null) {
            throw new IllegalArgumentException("first==null");
        }
        if (second == null) {
            throw new IllegalArgumentException("second==null");
        }
        if (third == null) {
            throw new IllegalArgumentException("third==null");
        }
        this.first = first;
        this.second = second;
        this.third = third;
    }

    @Override
    public <U extends Tok<P>> GR<P, U> map(final Fn3<T1, T2, T3, U> map) {
        if (map == null) {
            throw new IllegalArgumentException("map == null");
        }
        return new GR<P, U>(){
            private String name;
            private final SqNOPImpl<P> sq;
            {
                this.sq = new SqNOPImpl(Sq3OPImpl.this.first, Sq3OPImpl.this.second, Sq3OPImpl.this.third);
            }

            @Override
            public GR<P, U> name(String name) {
                this.name = name;
                return this;
            }

            @Override
            public String name() {
                return this.name;
            }

            public String toString() {
                if (this.name != null) {
                    return this.name;
                }
                return super.toString();
            }

            @Override
            public Optional<U> apply(P ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                Optional m = this.sq.name(this.name).match(ptr);
                if (m.isPresent()) {
                    Tok t2;
                    Tok t1;
                    List toks = m.get();
                    if (toks.size() < 3) {
                        throw new ImplementError("tokens count < 3");
                    }
                    Tok t0 = toks.get(0);
                    Tok t = (Tok)map.apply(t0, t1 = toks.get(1), t2 = toks.get(2));
                    if (t == null) {
                        throw new MapResultError("return null");
                    }
                    if (t.end().position() != t2.end().position()) {
                        throw new MapResultError("pointer order");
                    }
                    return Optional.of(t);
                }
                return Optional.empty();
            }
        };
    }

    @Override
    public <U extends Tok<P>> Sq4OP<P, T1, T2, T3, U> next(GR<P, U> fourth) {
        if (fourth == null) {
            throw new IllegalArgumentException("fourth==null");
        }
        return new Sq4OPImpl<P, T1, T2, T3, U>(this.first, this.second, this.third, fourth);
    }
}

