/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse.tmpl;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;

public interface Template
extends Function<Map, String> {
    @Override
    public String apply(Map var1);

    public static Template parse(String tmpl) {
        if (tmpl == null) {
            throw new IllegalArgumentException("tmpl==null");
        }
        ArrayList<Function<Map, String>> fns = new ArrayList<Function<Map, String>>();
        StringBuilder buff = new StringBuilder();
        String state = "begin";
        block22: for (int ci = 0; ci < tmpl.length(); ++ci) {
            char c0 = tmpl.charAt(ci);
            char c1 = ci < tmpl.length() - 1 ? tmpl.charAt(ci + 1) : (char)'\u0000';
            switch (state) {
                case "begin": {
                    switch (c0) {
                        case '\\': {
                            state = "escape";
                            continue block22;
                        }
                        case '$': {
                            state = "var0";
                            if (buff.length() <= 0) continue block22;
                            String res = buff.toString();
                            fns.add(args -> res);
                            buff.setLength(0);
                            continue block22;
                        }
                    }
                    buff.append(c0);
                    continue block22;
                }
                case "escape": {
                    buff.append(c0);
                    continue block22;
                }
                case "var0": {
                    switch (c0) {
                        case '{': {
                            state = "var1";
                            continue block22;
                        }
                    }
                    state = "begin";
                    continue block22;
                }
                case "var1": {
                    switch (c0) {
                        case '}': {
                            String varRef = buff.toString();
                            buff.setLength(0);
                            state = "begin";
                            fns.add(args -> args.getOrDefault(varRef, "").toString());
                            continue block22;
                        }
                    }
                    buff.append(c0);
                    continue block22;
                }
            }
        }
        if ("begin".equals(state) && buff.length() > 0) {
            String res = buff.toString();
            fns.add(args -> res);
            buff.setLength(0);
        }
        return args -> {
            if (args == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            fns.forEach(fn -> sb.append((String)fn.apply(args)));
            return sb.toString();
        };
    }
}

