/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.Iterator;
import java.util.function.Function;
import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Token;

public class TokenIterator
implements Iterator<Token> {
    private final Function<CharPointer, ? extends Token>[] parsers;
    protected Token current;

    public TokenIterator(CharPointer pointer, Function<CharPointer, ? extends Token>[] parsers) {
        if (parsers == null) {
            throw new IllegalArgumentException("parsers==null");
        }
        this.parsers = parsers;
        this.current = this.fetch(pointer);
    }

    protected Token fetch(CharPointer pointer) {
        if (pointer == null) {
            return null;
        }
        Function<CharPointer, ? extends Token>[] parsers = this.getParsers();
        if (parsers == null) {
            return null;
        }
        for (Function<CharPointer, ? extends Token> parser : parsers) {
            Token t;
            if (parser == null || (t = parser.apply(pointer)) == null) continue;
            return t;
        }
        return null;
    }

    public Function<CharPointer, ? extends Token>[] getParsers() {
        return this.parsers;
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public Token next() {
        Token result = this.current;
        if (result == null) {
            return null;
        }
        CharPointer cptr = result.getEnd();
        if (cptr != null) {
            Token next = this.fetch(cptr);
            if (next != null) {
                CharPointer nptr = next.getEnd();
                if (nptr == null) {
                    throw new IllegalStateException("next text pointer not available");
                }
                if (cptr.compareTo(nptr) >= 0) {
                    throw new IllegalStateException("next text pointer ref. to same (or less) text position");
                }
            }
            this.current = next;
        } else {
            this.current = null;
        }
        return result;
    }
}

