/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Tok;

public class Token
implements Tok<CharPointer> {
    protected final CharPointer begin;
    protected final CharPointer end;

    public Token(CharPointer begin, CharPointer end) {
        if (begin == null) {
            throw new IllegalArgumentException("begin==null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end==null");
        }
        if (begin.compareTo(end) > 0) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public Token(Token sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.begin = sample.getBegin();
        this.end = sample.getEnd();
    }

    public CharPointer getBegin() {
        return this.begin;
    }

    @Override
    public CharPointer getEnd() {
        return this.end;
    }

    public String getText() {
        return this.begin.text(Math.abs((Integer)this.end.pointer() - (Integer)this.begin.pointer()));
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " begin='" + this.begin.pointer() + "' text='" + this.getText() + "' >";
    }
}

