/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.ArrayList;
import java.util.function.Function;
import xyz.cofe.fn.Fn2;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.parse.Arr;
import xyz.cofe.text.parse.Pointer;
import xyz.cofe.text.parse.Tok;

public class Repeat<P extends Pointer, T extends Tok<P>>
implements Function<P, T> {
    private int min = 0;
    private int max = 0;
    private final Function<P, T> expression;
    private final Fn3<P, P, Arr<? super T>, T> builder;

    public Repeat(Function<P, T> expression, Fn3<P, P, Arr<? super T>, T> builder) {
        if (expression == null) {
            throw new IllegalArgumentException("expression==null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("builder==null");
        }
        this.expression = expression;
        this.builder = builder;
    }

    public Repeat(Repeat<P, T> sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.expression = sample.expression;
        this.builder = sample.builder;
        this.max = sample.max;
        this.min = sample.min;
    }

    public Repeat<P, T> clone() {
        return new Repeat<P, T>(this);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public Repeat<P, T> min(int min) {
        this.setMin(min);
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public Repeat<P, T> max(int max) {
        this.setMax(max);
        return this;
    }

    public Function<P, T> getExpression() {
        return this.expression;
    }

    @Override
    public T apply(P tp) {
        Tok t;
        if (tp == null) {
            throw new IllegalArgumentException("tp==null");
        }
        if (tp.eof()) {
            return null;
        }
        P begin = tp;
        ArrayList<Tok> toks = new ArrayList<Tok>();
        while (!(tp.eof() || this.max > 0 && toks.size() >= this.max || (t = (Tok)this.expression.apply(tp)) == null)) {
            Object nptr = t.getEnd();
            if (tp.compareTo(nptr) >= 0) {
                throw new Error("parser return empty token");
            }
            toks.add(t);
            tp = t.getEnd();
        }
        if (this.min > 0 && toks.size() < this.min) {
            return null;
        }
        return (T)this.build(begin, tp, new Arr(toks));
    }

    public Fn3<P, P, Arr<? super T>, T> getBuilder() {
        return this.builder;
    }

    private T build(P begin, P end, Arr<T> tokens) {
        return (T)((Tok)this.builder.apply(begin, end, tokens));
    }

    public <R extends T> Repeat<P, R> build(Fn3<P, P, Arr<R>, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Repeat<P, T> rep = new Repeat<P, T>(this.expression, fn);
        rep.setMax(this.getMax());
        rep.setMin(this.getMin());
        return rep;
    }

    public <R extends T> Repeat<P, R> build(Fn2<P, P, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        Repeat<P, T> rep = new Repeat<P, T>(this.expression, (begin, end, lst) -> (Tok)fn.apply(begin, end));
        rep.setMax(this.getMax());
        rep.setMin(this.getMin());
        return rep;
    }
}

