/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.function.BiFunction;
import java.util.function.Function;
import xyz.cofe.fn.Fn3;
import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Token;

public class CharAlternatives<T extends Token>
implements Function<CharPointer, Token> {
    private final Function<CharPointer, Token>[] expressions;
    private Fn3<CharPointer, CharPointer, Token, T> builder;

    public Function<CharPointer, Token>[] getExpressions() {
        return this.expressions;
    }

    public CharAlternatives(Function<CharPointer, Token>[] expressions) {
        if (expressions == null) {
            throw new IllegalArgumentException("expressions==null");
        }
        this.expressions = expressions;
    }

    public CharAlternatives(CharAlternatives<T> sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.expressions = sample.expressions;
        this.builder = sample.builder;
    }

    public CharAlternatives<T> clone() {
        return new CharAlternatives<T>(this);
    }

    @Override
    public T apply(CharPointer tp) {
        if (tp == null) {
            throw new IllegalArgumentException("tp==null");
        }
        if (tp.eof()) {
            return null;
        }
        CharPointer begin = tp;
        for (Function<CharPointer, Token> f : this.expressions) {
            Token t;
            if (f == null || (t = f.apply(tp)) == null) continue;
            CharPointer nptr = t.getEnd();
            if (tp.compareTo(nptr) >= 0) {
                throw new Error("parser return empty token");
            }
            return this.build(begin, nptr, t);
        }
        return null;
    }

    public <R extends Token> CharAlternatives<R> build(BiFunction<CharPointer, CharPointer, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        CharAlternatives<T> seq = new CharAlternatives<T>(this.expressions);
        seq.builder = (b, e, l) -> (Token)fn.apply((CharPointer)b, (CharPointer)e);
        return seq;
    }

    public <R extends Token> CharAlternatives<R> build(Fn3<CharPointer, CharPointer, Token, R> fn) {
        if (fn == null) {
            throw new IllegalArgumentException("fn==null");
        }
        CharAlternatives<T> seq = new CharAlternatives<T>(this.expressions);
        seq.builder = fn;
        return seq;
    }

    public Fn3<CharPointer, CharPointer, Token, T> getBuilder() {
        return this.builder;
    }

    private T build(CharPointer begin, CharPointer end, Token token) {
        if (this.builder != null) {
            return (T)((Token)this.builder.apply((Object)begin, (Object)end, (Object)token));
        }
        return (T)token;
    }
}

