/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.Objects;
import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Pointer;

public class BasicCharPointer
implements CharPointer {
    private final String source;
    private final int pointer;

    public BasicCharPointer(String source, int ptr) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        this.source = source;
        this.pointer = ptr;
    }

    public BasicCharPointer(BasicCharPointer sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        String src = sample.source;
        this.source = src == null ? "" : src;
        this.pointer = sample.pointer();
    }

    @Override
    public Integer pointer() {
        return this.pointer;
    }

    @Override
    public boolean eof() {
        return this.pointer >= this.source.length() || this.pointer < 0;
    }

    @Override
    public String text(int length) {
        if (this.eof()) {
            return "";
        }
        if (length <= 0) {
            return "";
        }
        int t = this.pointer + length;
        if (t <= this.pointer) {
            return "";
        }
        if (t <= this.source.length()) {
            return this.source.substring(this.pointer, t);
        }
        return this.source.substring(this.pointer);
    }

    @Override
    public Character lookup() {
        if (this.eof()) {
            return Character.valueOf('\u0000');
        }
        return Character.valueOf(this.source.charAt(this.pointer));
    }

    @Override
    public BasicCharPointer move(int offset) {
        return new BasicCharPointer(this.source, this.pointer + offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicCharPointer that = (BasicCharPointer)o;
        return this.pointer == that.pointer && this.source.equals(that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.pointer);
    }

    public String toString() {
        return "<Ptr pointer=" + this.pointer + '>';
    }

    @Override
    public int compareTo(Pointer o) {
        if (o == null) {
            return 0;
        }
        if (o.getClass() != BasicCharPointer.class) {
            return 0;
        }
        BasicCharPointer p = (BasicCharPointer)o;
        if (p.source != this.source) {
            return 0;
        }
        return this.pointer < p.pointer ? -1 : (this.pointer == p.pointer ? 0 : 1);
    }
}

