/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarDockStation;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public abstract class SpanToolbarLayoutManager
implements LayoutManager2 {
    private ToolbarDockStation station;
    private Container parent;
    private Span[] spans = new Span[0];
    private StationSpanFactoryValue factory;
    private int size;
    private int index = -1;
    private int gap = 3;
    private int sideGap = 5;

    public SpanToolbarLayoutManager(ToolbarDockStation station, Container parent) {
        this.parent = parent;
        this.station = station;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.toolbar", station){

            protected void changed() {
                SpanToolbarLayoutManager.this.reset();
            }
        };
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException("gap must not be smaller than 0");
        }
        this.gap = gap;
    }

    public int getSideGap() {
        return this.sideGap;
    }

    public void setSideGap(int sideGap) {
        if (sideGap < 0) {
            throw new IllegalArgumentException("sideGap must not be smaller than 0");
        }
        this.sideGap = sideGap;
    }

    public void setController(DockController controller) {
        this.factory.setController(controller);
    }

    public int getInsertionIndex(int x, int y) {
        Component child;
        int i;
        int location;
        if (this.station.getDockableCount() == 0) {
            return 0;
        }
        int[] positions = new int[this.parent.getComponentCount()];
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            location = x;
            for (i = 0; i < positions.length; ++i) {
                child = this.parent.getComponent(i);
                positions[i] = child.getX() + child.getWidth() / 2;
            }
        } else {
            location = y;
            for (i = 0; i < positions.length; ++i) {
                child = this.parent.getComponent(i);
                positions[i] = child.getY() + child.getHeight() / 2;
            }
        }
        for (i = 0; i < positions.length; ++i) {
            if (location > positions[i]) continue;
            return i;
        }
        return positions.length;
    }

    public void setSpanSize(Dockable moved) {
        Dimension dim = moved.getComponent().getPreferredSize();
        int size = this.station.getOrientation() == Orientation.HORIZONTAL ? dim.width : dim.height;
        if (this.size != size) {
            this.size = size;
            for (Span span : this.spans) {
                span.configureSize(SpanMode.OPEN, size);
            }
        }
    }

    public void setExpandedSpan(int index, boolean mutate) {
        block6: {
            if (this.index == index) break block6;
            this.index = index;
            if (mutate) {
                for (int i = 0; i < this.spans.length; ++i) {
                    if (i == index) {
                        this.spans[i].mutate(SpanMode.OPEN);
                        continue;
                    }
                    this.spans[i].mutate(SpanMode.OFF);
                }
            } else {
                for (int i = 0; i < this.spans.length; ++i) {
                    if (i == index) {
                        this.spans[i].set(SpanMode.OPEN);
                        continue;
                    }
                    this.spans[i].set(SpanMode.OFF);
                }
            }
        }
    }

    protected abstract void revalidate();

    private void reset() {
        this.index = -1;
        int count = this.station.getDockableCount() + 1;
        if (this.spans.length != count) {
            SpanCallback callback = new SpanCallback(){

                public DockStation getStation() {
                    return SpanToolbarLayoutManager.this.station;
                }

                public boolean isHorizontal() {
                    return SpanToolbarLayoutManager.this.station.getOrientation() == Orientation.HORIZONTAL;
                }

                public boolean isVertical() {
                    return SpanToolbarLayoutManager.this.station.getOrientation() == Orientation.VERTICAL;
                }

                public void resized() {
                    SpanToolbarLayoutManager.this.revalidate();
                }

                public SpanUsage getUsage() {
                    return SpanUsage.INSERTING;
                }
            };
            this.spans = new Span[count];
            for (int i = 0; i < count; ++i) {
                this.spans[i] = this.factory.create(callback);
                this.spans[i].configureSize(SpanMode.OPEN, this.size);
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.reset();
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.reset();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        int deltaWidth = 0;
        int deltaHeight = 0;
        if (insets != null) {
            deltaWidth += insets.left + insets.right;
            deltaHeight += insets.top + insets.bottom;
        }
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            int width = 0;
            int height = 0;
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = parent.getComponent(i);
                Dimension size = child.getPreferredSize();
                width += size.width;
                width = i == 0 ? (width += this.sideGap) : (width += this.gap);
                height = Math.max(height, size.height);
            }
            width += this.sideGap;
            for (Span span : this.spans) {
                width += span.getSize();
            }
            return new Dimension(width + deltaWidth, height + 2 * this.sideGap + deltaHeight);
        }
        int width = 0;
        int height = 0;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component child = parent.getComponent(i);
            Dimension size = child.getPreferredSize();
            height += size.height;
            height = i == 0 ? (height += this.sideGap) : (height += this.gap);
            width = Math.max(width, size.width);
        }
        height += this.sideGap;
        for (Span span : this.spans) {
            height += span.getSize();
        }
        return new Dimension(width + 2 * this.sideGap + deltaWidth, height + deltaHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int x = 0;
        int y = 0;
        int width = parent.getWidth();
        int height = parent.getHeight();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
            width = Math.max(width, 1);
            height = Math.max(height, 1);
        }
        if (this.station.getOrientation() == Orientation.HORIZONTAL) {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                int span = 0;
                if (i < this.spans.length) {
                    span = this.spans[i].getSize();
                }
                x += span;
                x = i == 0 ? (x += this.sideGap) : (x += this.gap);
                Component comp = parent.getComponent(i);
                Dimension size = comp.getPreferredSize();
                comp.setBounds(x, y + this.sideGap, size.width, height - 2 * this.sideGap);
                x += size.width;
            }
        } else {
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                int span = 0;
                if (i < this.spans.length) {
                    span = this.spans[i].getSize();
                }
                y += span;
                y = i == 0 ? (y += this.sideGap) : (y += this.gap);
                Component comp = parent.getComponent(i);
                Dimension size = comp.getPreferredSize();
                comp.setBounds(x + this.sideGap, y, width - 2 * this.sideGap, size.height);
                y += size.height;
            }
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.reset();
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

