/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.wizard.PersistentCell;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class WizardNodeMap {
    private Map<SplitNode, Column> columns;
    private WizardSplitDockStation station;
    private PersistentColumn[] persistentColumns;

    public WizardNodeMap(WizardSplitDockStation station, PersistentColumn[] persistentColumns) {
        this.station = station;
        this.persistentColumns = persistentColumns;
    }

    private void buildColumns() {
        this.columns = new HashMap<SplitNode, Column>();
        this.station.getRoot().visit(new SplitNodeVisitor(){

            public void handleRoot(Root root) {
            }

            public void handleNode(Node node) {
                if (WizardNodeMap.this.isColumnRoot((SplitNode)node)) {
                    WizardNodeMap.this.columns.put(node, new Column((SplitNode)node));
                }
            }

            public void handleLeaf(Leaf leaf) {
                if (WizardNodeMap.this.isColumnRoot((SplitNode)leaf)) {
                    WizardNodeMap.this.columns.put(leaf, new Column((SplitNode)leaf));
                }
            }

            public void handlePlaceholder(Placeholder placeholder) {
            }
        });
        Column[] array = this.columns.values().toArray(new Column[this.columns.size()]);
        Arrays.sort(array, new Comparator<Column>(){

            @Override
            public int compare(Column a, Column b) {
                int sb;
                int sa = this.score(a);
                if (sa < (sb = this.score(b))) {
                    return -1;
                }
                if (sa > sb) {
                    return 1;
                }
                return 0;
            }

            private int score(Column c) {
                int score = 0;
                SplitNode root = c.root;
                while (root != null) {
                    SplitNode parent = root.getParent();
                    if (parent != null && parent.getChildLocation(root) > 0) {
                        ++score;
                    }
                    root = parent;
                }
                return score;
            }
        });
        for (int i = 0; i < array.length; ++i) {
            array[i].index = i;
        }
    }

    public Map<SplitNode, Column> getColumns() {
        if (this.columns == null) {
            this.buildColumns();
        }
        return this.columns;
    }

    public int getColumnCount() {
        return this.getColumns().size();
    }

    public Column getColumn(int index) {
        for (Column column : this.getColumns().values()) {
            if (column.index != index) continue;
            return column;
        }
        throw new IndexOutOfBoundsException("index: " + index);
    }

    public Column[] getSortedColumns() {
        Collection<Column> columns = this.getColumns().values();
        Column[] array = columns.toArray(new Column[columns.size()]);
        Arrays.sort(array, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        return array;
    }

    public boolean isColumnRoot(SplitNode node) {
        if (node instanceof Root) {
            return false;
        }
        if (node instanceof Node) {
            Node n = (Node)node;
            if (n.getOrientation() == this.side().getHeaderOrientation()) {
                return false;
            }
            if (n.getLeft() == null || !n.getLeft().isVisible()) {
                return false;
            }
            if (n.getRight() == null || !n.getRight().isVisible()) {
                return false;
            }
            return this.isHeaderLevel(node);
        }
        if (node instanceof Leaf) {
            return this.isHeaderLevel(node, false);
        }
        return false;
    }

    public boolean isHeaderLevel(SplitNode node) {
        return this.isHeaderLevel(node, true);
    }

    public boolean isHeaderLevel(SplitNode node, boolean recursive) {
        if (node instanceof Root) {
            return true;
        }
        if (node instanceof Node) {
            Node n = (Node)node;
            if (n.getLeft() == null || n.getRight() == null) {
                return false;
            }
            if (!n.getLeft().isVisible() || !n.getRight().isVisible()) {
                return this.isHeaderLevel(node.getParent(), recursive);
            }
            if (n.getOrientation() == this.side().getHeaderOrientation()) {
                return true;
            }
            if (recursive) {
                return this.isHeaderLevel(node.getParent(), false);
            }
            return false;
        }
        if (node.getParent() instanceof Root) {
            return true;
        }
        if (node instanceof Leaf) {
            return this.isHeaderLevel(node.getParent(), false);
        }
        return false;
    }

    private WizardSplitDockStation.Side side() {
        return this.station.getSide();
    }

    public Column getOutermostColumn() {
        return this.getHeadColumn((SplitNode)this.station.getRoot());
    }

    public Column getHeadColumn(SplitNode node) {
        while (node != null) {
            Column column = this.getColumns().get(node);
            if (column != null) {
                return column;
            }
            if (node instanceof Node) {
                if (((Node)node).getLeft() == null || !((Node)node).getLeft().isVisible()) {
                    node = ((Node)node).getRight();
                    continue;
                }
                if (((Node)node).getRight() == null || !((Node)node).getRight().isVisible()) {
                    node = ((Node)node).getLeft();
                    continue;
                }
                if (this.side() == WizardSplitDockStation.Side.RIGHT || this.side() == WizardSplitDockStation.Side.BOTTOM) {
                    node = ((Node)node).getLeft();
                    continue;
                }
                node = ((Node)node).getRight();
                continue;
            }
            if (node instanceof Root) {
                node = ((Root)node).getChild();
                continue;
            }
            node = null;
        }
        return null;
    }

    public PersistentCell getHeadCell(SplitNode node) {
        while (node != null) {
            if (node instanceof Leaf) {
                Dockable dockable = ((Leaf)node).getDockable();
                for (Column column : this.getColumns().values()) {
                    PersistentCell cell;
                    if (column.cells.get(node) == null || (cell = column.getPersistentColumn().getCells().get(dockable)) == null) continue;
                    return cell;
                }
                node = null;
            }
            if (node instanceof Node) {
                node = ((Node)node).getRight();
                continue;
            }
            node = null;
        }
        return null;
    }

    public Column getColumn(SplitNode node) {
        Column column = this.getColumn(node, true);
        if (column != null) {
            return column;
        }
        if (node instanceof Root) {
            node = ((Root)node).getChild();
        }
        if (node instanceof Node) {
            SplitNode child = ((Node)node).getRight();
            while (child != null) {
                Column result = this.getColumns().get(child);
                if (result != null) {
                    return result;
                }
                if (child instanceof Node) {
                    child = ((Node)child).getLeft();
                    continue;
                }
                child = null;
            }
        }
        return null;
    }

    public Column getColumn(SplitNode node, boolean upwards) {
        if (upwards) {
            Column column = null;
            while (node != null && column == null) {
                column = this.getColumns().get(node);
                node = node.getParent();
            }
            return column;
        }
        return this.getColumns().get(node);
    }

    public Column getColumn(Dockable dockable) {
        for (Column column : this.getColumns().values()) {
            if (!column.getLeafs().containsKey(dockable)) continue;
            return column;
        }
        return null;
    }

    public Leaf[] getLastLeafOfColumns() {
        ArrayList<Leaf> result = new ArrayList<Leaf>();
        for (Column column : this.getColumns().values()) {
            Leaf last = column.getLastLeafOfColumn();
            if (last == null) continue;
            result.add(last);
        }
        return result.toArray(new Leaf[result.size()]);
    }

    public PersistentColumn getPersistentColumn(int index) {
        for (PersistentColumn column : this.getPersistentColumns()) {
            if (column.getSource().index != index) continue;
            return column;
        }
        return null;
    }

    public PersistentColumn[] getPersistentColumns() {
        ArrayList<PersistentColumn> result = new ArrayList<PersistentColumn>(this.getColumns().size());
        for (Column column : this.getColumns().values()) {
            PersistentColumn next = column.toPersistentColumn();
            if (next == null) continue;
            result.add(next);
        }
        this.persistentColumns = this.persistentColumns == null ? result.toArray(new PersistentColumn[result.size()]) : this.adapt(this.persistentColumns, result.toArray(new PersistentColumn[result.size()]));
        this.handlePersistentColumnsAdapted(this.persistentColumns);
        return this.persistentColumns;
    }

    protected abstract void handlePersistentColumnsAdapted(PersistentColumn[] var1);

    private PersistentColumn[] adapt(PersistentColumn[] oldColumns, PersistentColumn[] newColumns) {
        for (PersistentColumn column : newColumns) {
            HashSet<PersistentColumn> sources = new HashSet<PersistentColumn>();
            block1: for (Map.Entry<Dockable, PersistentCell> entry : column.getCells().entrySet()) {
                for (PersistentColumn source : oldColumns) {
                    PersistentCell cell = source.getCells().get(entry.getKey());
                    if (cell == null) continue;
                    sources.add(source);
                    entry.getValue().setSize(cell.getSize());
                    continue block1;
                }
            }
            if (sources.size() == 1) {
                PersistentColumn source = (PersistentColumn)sources.iterator().next();
                if (source.getCells().keySet().containsAll(column.getCells().keySet())) {
                    column.setSize(source.getSize());
                    continue;
                }
                column.setSize(Math.max(source.getSize(), column.getPreferredSize()));
                continue;
            }
            if (sources.size() <= 0) continue;
            int max = 0;
            for (PersistentColumn source : sources) {
                max = Math.max(max, source.getSize());
            }
            column.setSize(max);
        }
        return newColumns;
    }

    public class Cell {
        private SplitNode node;
        private Column column;
        private Dimension preferredSize;
        private Dimension minimumSize;
        private int index;

        private Cell(SplitNode node, Column column) {
            this.node = node;
            this.column = column;
        }

        public SplitNode getNode() {
            return this.node;
        }

        public int getIndex() {
            return this.index;
        }

        public Dimension getPreferredSize() {
            if (this.preferredSize == null) {
                DockableDisplayer displayer;
                if (this.node instanceof Leaf && (displayer = ((Leaf)this.node).getDisplayer()) != null) {
                    this.preferredSize = displayer.getComponent().getPreferredSize();
                }
                if (this.node instanceof Node) {
                    Dimension left = this.column.getPreferredSize(((Node)this.node).getLeft());
                    Dimension right = this.column.getPreferredSize(((Node)this.node).getRight());
                    if (left == null) {
                        this.preferredSize = right;
                    } else if (right == null) {
                        this.preferredSize = left;
                    } else if (left != null && right != null) {
                        this.preferredSize = ((Node)this.node).getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(left.width + right.width, Math.max(left.height, right.height)) : new Dimension(Math.max(left.width, right.width), left.height + right.height);
                    }
                }
                if (this.node instanceof Root) {
                    this.preferredSize = this.column.getPreferredSize(((Root)this.node).getChild());
                }
            }
            return this.preferredSize;
        }

        public Dimension getMinimumSize() {
            if (this.minimumSize == null) {
                DockableDisplayer displayer;
                if (this.node instanceof Leaf && (displayer = ((Leaf)this.node).getDisplayer()) != null) {
                    this.minimumSize = displayer.getComponent().getMinimumSize();
                }
                if (this.node instanceof Node) {
                    Dimension left = this.column.getMinimumSize(((Node)this.node).getLeft());
                    Dimension right = this.column.getMinimumSize(((Node)this.node).getRight());
                    if (left == null) {
                        this.minimumSize = right;
                    } else if (right == null) {
                        this.minimumSize = left;
                    } else if (left != null && right != null) {
                        this.minimumSize = ((Node)this.node).getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? new Dimension(left.width + right.width, Math.max(left.height, right.height)) : new Dimension(Math.max(left.width, right.width), left.height + right.height);
                    }
                }
                if (this.node instanceof Root) {
                    this.minimumSize = this.column.getMinimumSize(((Root)this.node).getChild());
                }
            }
            return this.minimumSize;
        }

        public int getGaps() {
            if (this.node instanceof Leaf) {
                return 0;
            }
            if (this.node instanceof Node) {
                int left = this.column.getGaps(((Node)this.node).getLeft());
                int right = this.column.getGaps(((Node)this.node).getRight());
                if (left == -1) {
                    return right;
                }
                if (right == -1) {
                    return left;
                }
                if (left == -1 && right == -1) {
                    return -1;
                }
                return left + 1 + right;
            }
            if (this.node instanceof Root) {
                return this.column.getGaps(((Root)this.node).getChild());
            }
            return -1;
        }
    }

    public class Column {
        private SplitNode root;
        private Map<SplitNode, Cell> cells = new HashMap<SplitNode, Cell>();
        private List<Cell> leafCells = new ArrayList<Cell>();
        private int index;

        private Column(SplitNode root) {
            this.root = root;
            root.visit(new SplitNodeVisitor(){

                public void handleRoot(Root root) {
                    Column.this.cells.put(root, new Cell((SplitNode)root, Column.this));
                }

                public void handlePlaceholder(Placeholder placeholder) {
                    Column.this.cells.put(placeholder, new Cell((SplitNode)placeholder, Column.this));
                }

                public void handleNode(Node node) {
                    Column.this.cells.put(node, new Cell((SplitNode)node, Column.this));
                }

                public void handleLeaf(Leaf leaf) {
                    Cell cell = new Cell((SplitNode)leaf, Column.this);
                    Column.this.cells.put(leaf, cell);
                    Column.this.leafCells.add(cell);
                }
            });
            Cell[] array = this.leafCells.toArray(new Cell[this.leafCells.size()]);
            Arrays.sort(array, new Comparator<Cell>(){

                @Override
                public int compare(Cell a, Cell b) {
                    int sb;
                    int sa = this.score(a);
                    if (sa < (sb = this.score(b))) {
                        return -1;
                    }
                    if (sa > sb) {
                        return 1;
                    }
                    return 0;
                }

                private int score(Cell c) {
                    int score = 0;
                    for (SplitNode node = c.getNode(); node != Column.this.root; node = node.getParent()) {
                        if (node.getParent().getChildLocation(node) <= 0) continue;
                        ++score;
                    }
                    return score;
                }
            });
            for (int i = 0; i < array.length; ++i) {
                array[i].index = i;
            }
        }

        public SplitNode getRoot() {
            return this.root;
        }

        public Cell[] getSortedCells() {
            Cell[] array = this.cells.values().toArray(new Cell[this.cells.size()]);
            Arrays.sort(array, new Comparator<Cell>(){

                @Override
                public int compare(Cell o1, Cell o2) {
                    return o1.getIndex() - o2.getIndex();
                }
            });
            return array;
        }

        public PersistentColumn toPersistentColumn() {
            int preferred;
            int size;
            Map<Dockable, PersistentCell> leafs = this.getLeafs();
            if (leafs.size() == 0) {
                return null;
            }
            if (WizardNodeMap.this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                size = this.root.getSize().width;
                preferred = this.getPreferredSize().width;
            } else {
                size = this.root.getSize().height;
                preferred = this.getPreferredSize().height;
            }
            return new PersistentColumn(size, preferred, this, leafs);
        }

        public int getIndex() {
            return this.index;
        }

        public PersistentColumn getPersistentColumn() {
            Map<Dockable, PersistentCell> leafs = this.getLeafs();
            for (PersistentColumn column : WizardNodeMap.this.getPersistentColumns()) {
                if (!column.getCells().keySet().equals(leafs.keySet())) continue;
                return column;
            }
            return null;
        }

        private Map<Dockable, PersistentCell> getLeafs() {
            final HashMap<Dockable, PersistentCell> leafs = new HashMap<Dockable, PersistentCell>();
            this.root.visit(new SplitNodeVisitor(){

                public void handleRoot(Root root) {
                }

                public void handlePlaceholder(Placeholder placeholder) {
                }

                public void handleNode(Node node) {
                }

                public void handleLeaf(Leaf leaf) {
                    Dimension preferredSize = Column.this.getPreferredSize((SplitNode)leaf);
                    if (preferredSize != null) {
                        int preferred;
                        int size;
                        if (WizardNodeMap.this.side().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                            size = leaf.getSize().height;
                            preferred = preferredSize.height;
                        } else {
                            size = leaf.getSize().width;
                            preferred = preferredSize.width;
                        }
                        leafs.put(leaf.getDockable(), new PersistentCell(size, preferred));
                    }
                }
            });
            return leafs;
        }

        public Cell getRightmostCell(SplitNode node) {
            while (node != null) {
                if (node instanceof Node) {
                    node = ((Node)node).getRight();
                    continue;
                }
                return this.cells.get(node);
            }
            return null;
        }

        public Cell getLeftmostCell(SplitNode node) {
            while (node != null) {
                if (node instanceof Node) {
                    node = ((Node)node).getLeft();
                    continue;
                }
                return this.cells.get(node);
            }
            return null;
        }

        public Leaf getLastLeafOfColumn() {
            SplitNode node = this.root;
            while (node != null) {
                if (node instanceof Root) {
                    node = ((Root)node).getChild();
                    continue;
                }
                if (node instanceof Node) {
                    node = ((Node)node).getRight();
                    continue;
                }
                if (node instanceof Leaf) {
                    return (Leaf)node;
                }
                node = null;
            }
            return null;
        }

        public Dimension getPreferredSize(SplitNode node) {
            Cell cell = this.cells.get(node);
            if (cell == null) {
                return null;
            }
            return cell.getPreferredSize();
        }

        public Dimension getMinimumSize(SplitNode node) {
            Cell cell = this.cells.get(node);
            if (cell == null) {
                return null;
            }
            return cell.getMinimumSize();
        }

        public Dimension getPreferredSize() {
            return this.getPreferredSize(this.root);
        }

        public Dimension getMinimumSize() {
            return this.getMinimumSize(this.root);
        }

        public Rectangle getBounds() {
            return this.root.getBounds();
        }

        public int getCellCount() {
            return this.leafCells.size();
        }

        public int getGaps(SplitNode node) {
            Cell cell = this.cells.get(node);
            if (cell == null) {
                return 0;
            }
            return cell.getGaps();
        }

        public int getGaps() {
            return this.getGaps(this.root);
        }
    }
}

