/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.Divideable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Rectangle;

public class CellDivider
implements Divideable {
    private WizardSplitDockStation station;
    private Leaf leaf;

    public CellDivider(WizardSplitDockStation station, Leaf leaf) {
        this.station = station;
        this.leaf = leaf;
    }

    public Leaf getLeaf() {
        return this.leaf;
    }

    public double getDividerAt(int x, int y) {
        Rectangle bounds = this.leaf.getBounds();
        int gap = this.station.getDividerSize();
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                return (double)(y - bounds.y + gap / 2) / (double)(bounds.height + gap / 2);
            }
            case BOTTOM: 
            case TOP: {
                return (double)(x - bounds.x + gap / 2) / (double)(bounds.width + gap / 2);
            }
        }
        throw new IllegalArgumentException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    public Rectangle getDividerBounds(double divider, Rectangle bounds) {
        if (bounds == null) {
            bounds = new Rectangle();
        }
        Rectangle leafBounds = this.leaf.getBounds();
        int gap = this.station.getDividerSize();
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                bounds.x = leafBounds.x;
                bounds.width = leafBounds.width;
                bounds.height = gap;
                bounds.y = (int)(divider * (double)(leafBounds.height + gap / 2) + (double)leafBounds.y - (double)(gap / 2));
                return bounds;
            }
            case BOTTOM: 
            case TOP: {
                bounds.y = leafBounds.y;
                bounds.height = leafBounds.height;
                bounds.width = gap;
                bounds.x = (int)(divider * (double)(leafBounds.width + gap / 2) + (double)leafBounds.x - (double)(gap / 2));
                return bounds;
            }
        }
        throw new IllegalArgumentException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    public SplitDockStation.Orientation getOrientation() {
        switch (this.station.getSide()) {
            case LEFT: 
            case RIGHT: {
                return SplitDockStation.Orientation.VERTICAL;
            }
            case BOTTOM: 
            case TOP: {
                return SplitDockStation.Orientation.HORIZONTAL;
            }
        }
        throw new IllegalStateException("unknown side: " + (Object)((Object)this.station.getSide()));
    }

    public double getDivider() {
        return 1.0;
    }

    public double getActualDivider() {
        return this.getDivider();
    }

    public void setDivider(double dividier) {
    }

    public double validateDivider(double divider) {
        return this.station.getWizardSplitLayoutManager().validateDivider(divider, this.leaf);
    }
}

