/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.AbstractDockableCStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonStationDelegate;
import bibliothek.gui.dock.common.intern.station.SplitResizeRequestHandler;
import bibliothek.gui.dock.common.location.CGridAreaLocation;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.station.CSplitDockStationHandle;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Path;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CGridArea
extends AbstractDockableCStation<CSplitDockStation>
implements SingleCDockable {
    public static final Path TYPE_ID = new Path(new String[]{"dock", "CGridArea"});
    private String uniqueId;
    private CSplitDockStation station;
    private SplitResizeRequestHandler resizeRequestHandler;
    private CSplitDockStationHandle modeManagerHandle;
    private boolean maximizing = false;

    public CGridArea(CControl control, String uniqueId) {
        this.init(control, uniqueId);
    }

    protected CGridArea() {
    }

    protected void init(CControl control, String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("id must not be null");
        }
        this.uniqueId = uniqueId;
        CommonDockStation<SplitDockStation, CSplitDockStation> station = control.getFactory().createSplitDockStation(new Delegate());
        this.station = station.asDockStation();
        this.init(station.asDockable());
        this.setTitleShown(false);
        this.station.setExpandOnDoubleclick(false);
        this.resizeRequestHandler = new SplitResizeRequestHandler(this.station);
        this.setMaximizingArea(true);
        this.modeManagerHandle = this.createSplitDockStationHandle(control);
    }

    protected CSplitDockStationHandle createSplitDockStationHandle(CControl control) {
        return new CSplitDockStationHandle(this, control.getLocationManager());
    }

    @Override
    protected CommonDockable createCommonDockable() {
        throw new IllegalStateException("the common-dockable gets already initialized by the constructor");
    }

    public void deploy(CGrid grid) {
        this.station.dropTree((SplitDockTree)grid.toTree());
    }

    @Override
    public CSplitDockStation getStation() {
        return this.station;
    }

    @Override
    public CDockable asDockable() {
        return this;
    }

    @Override
    public CStationPerspective createPerspective() {
        return new CGridPerspective(this.getUniqueId(), this.getTypeId(), this.isWorkingArea());
    }

    public JComponent getComponent() {
        return this.station;
    }

    @Override
    public CLocation getStationLocation() {
        return new CGridAreaLocation(this);
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }

    public void setTitleText(String text) {
        this.station.setTitleText(text);
    }

    public String getTitleText() {
        return this.station.getTitleText();
    }

    public void setTitleIcon(Icon icon) {
        this.station.setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.station.getTitleIcon();
    }

    public void setMaximizingArea(boolean maximize) {
        if (maximize != this.maximizing) {
            this.maximizing = maximize;
            CControl access = this.getControl();
            if (access != null) {
                CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
                if (this.maximizing) {
                    mode.add(this.modeManagerHandle.asMaximziedModeArea());
                } else {
                    mode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
                }
            }
        }
    }

    public boolean isMaximizingArea() {
        return this.maximizing;
    }

    protected boolean isNormalizingArea() {
        return true;
    }

    protected CSplitDockStationHandle getModeManagerHandle() {
        return this.modeManagerHandle;
    }

    @Override
    protected void install(CControlAccess access) {
        if (this.isNormalizingArea()) {
            access.getLocationManager().getNormalMode().add(this.modeManagerHandle.asNormalModeArea());
            access.getOwner().addResizeRequestListener(this.resizeRequestHandler);
        }
        if (this.isMaximizingArea()) {
            CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
            mode.add(this.modeManagerHandle.asMaximziedModeArea());
        }
    }

    @Override
    protected void uninstall(CControlAccess access) {
        if (this.isNormalizingArea()) {
            access.getLocationManager().getNormalMode().remove(this.modeManagerHandle.asNormalModeArea().getUniqueId());
            access.getOwner().removeResizeRequestListener(this.resizeRequestHandler);
        }
        if (this.isMaximizingArea()) {
            CMaximizedMode mode = access.getLocationManager().getMaximizedMode();
            mode.remove(this.modeManagerHandle.asMaximziedModeArea().getUniqueId());
        }
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public boolean isExternalizable() {
        return false;
    }

    @Override
    public boolean isMaximizable() {
        return false;
    }

    @Override
    public boolean isMinimizable() {
        return false;
    }

    @Override
    public boolean isStackable() {
        return false;
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    protected boolean suppressTitle(DockTitleVersion version) {
        if (!this.isTitleShown()) {
            if (version.getID().equals("split")) {
                return true;
            }
            if (version.getID().equals("flap window")) {
                return true;
            }
            if (version.getID().equals("screen dock")) {
                return true;
            }
            if (version.getID().equals("stack")) {
                return true;
            }
        }
        return false;
    }

    private class Delegate
    implements CommonStationDelegate<CSplitDockStation> {
        private Delegate() {
        }

        @Override
        public CDockable getDockable() {
            return CGridArea.this;
        }

        @Override
        public DockActionSource[] getSources() {
            return new DockActionSource[]{CGridArea.this.getClose()};
        }

        @Override
        public CStation<CSplitDockStation> getStation() {
            return CGridArea.this;
        }

        @Override
        public boolean isTitleDisplayed(DockTitleVersion title) {
            return !CGridArea.this.suppressTitle(title);
        }
    }
}

