/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockFrontendListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CPlaceholderStrategy
implements PlaceholderStrategy {
    private CControl control;
    private List<PlaceholderStrategyListener> listeners = new ArrayList<PlaceholderStrategyListener>();
    private Map<MultipleCDockable, Path> multiplePlaceholders = new HashMap<MultipleCDockable, Path>();
    private CControlListener controlListener = new CControlListener(){

        @Override
        public void removed(CControl control, CDockable dockable) {
            Path check;
            if (dockable instanceof SingleCDockable) {
                String id = ((SingleCDockable)dockable).getUniqueId();
                Path check2 = CPlaceholderStrategy.getSingleDockablePlaceholder(id);
                if (!CPlaceholderStrategy.this.isValidPlaceholder(check2)) {
                    CPlaceholderStrategy.this.fireInvalidated(check2);
                }
            } else if (dockable instanceof MultipleCDockable && (check = (Path)CPlaceholderStrategy.this.multiplePlaceholders.remove(dockable)) != null && !CPlaceholderStrategy.this.isValidPlaceholder(check)) {
                CPlaceholderStrategy.this.fireInvalidated(check);
            }
        }

        @Override
        public void opened(CControl control, CDockable dockable) {
        }

        @Override
        public void closed(CControl control, CDockable dockable) {
        }

        @Override
        public void added(CControl control, CDockable dockable) {
        }
    };
    private Set<Path> pendingChecks = null;
    private CDockFrontendListener frontendListener = new CDockFrontendListener(){

        @Override
        public void loading(CDockFrontend frontend, CSetting setting) {
            CPlaceholderStrategy.this.pendingChecks = new HashSet();
        }

        @Override
        public void loaded(CDockFrontend frontend, CSetting setting) {
            if (CPlaceholderStrategy.this.pendingChecks != null) {
                Set pendingChecks = CPlaceholderStrategy.this.pendingChecks;
                CPlaceholderStrategy.this.pendingChecks = null;
                for (Path check : pendingChecks) {
                    if (CPlaceholderStrategy.this.isValidPlaceholder(check)) continue;
                    CPlaceholderStrategy.this.fireInvalidated(check);
                }
            }
        }
    };

    public static Path getSingleDockablePlaceholder(String id) {
        return new Path(new String[]{"dock", "single", id});
    }

    public static Path getMultipleDockablePlaceholder(String id) {
        return new Path(new String[]{"dock", "multi", id});
    }

    public CPlaceholderStrategy(CControl control) {
        this.control = control;
    }

    public void addListener(PlaceholderStrategyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listeners.isEmpty()) {
            this.control.addControlListener(this.controlListener);
            this.control.intern().addListener(this.frontendListener);
        }
        this.listeners.add(listener);
    }

    public void removeListener(PlaceholderStrategyListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.control.removeControlListener(this.controlListener);
            this.control.intern().removeListener(this.frontendListener);
            this.frontendListener.loaded(null, null);
        }
    }

    protected void fireInvalidated(Path placeholder) {
        Set<Object> placeholders = new HashSet<Path>();
        placeholders.add(placeholder);
        placeholders = Collections.unmodifiableSet(placeholders);
        for (PlaceholderStrategyListener listener : this.listeners.toArray(new PlaceholderStrategyListener[this.listeners.size()])) {
            listener.placeholderInvalidated(placeholders);
        }
    }

    public Path getPlaceholderFor(Dockable dockable) {
        CDockableAccess access;
        if (!(dockable instanceof CommonDockable)) {
            return null;
        }
        CDockable cdockable = ((CommonDockable)dockable).getDockable();
        CControlAccess controlAccess = cdockable.getControlAccess();
        if (controlAccess == null || controlAccess.getOwner() != this.control) {
            return null;
        }
        if (cdockable instanceof SingleCDockable) {
            String id = ((SingleCDockable)cdockable).getUniqueId();
            return CPlaceholderStrategy.getSingleDockablePlaceholder(id);
        }
        if (cdockable instanceof MultipleCDockable && (access = controlAccess.access(cdockable)) != null) {
            Path result = CPlaceholderStrategy.getMultipleDockablePlaceholder(controlAccess.getRegister().multiToNormalId(access.getUniqueId()));
            this.multiplePlaceholders.put((MultipleCDockable)cdockable, result);
            return result;
        }
        return null;
    }

    public boolean isValidPlaceholder(Path placeholder) {
        String id;
        if (placeholder.getSegmentCount() != 3) {
            return true;
        }
        if (!placeholder.getSegment(0).equals("dock")) {
            return true;
        }
        if (placeholder.getSegment(1).equals("single")) {
            id = placeholder.getSegment(2);
            if (this.control.getSingleDockable(id) != null) {
                return true;
            }
            if (this.control.getSingleDockableFactory(id) != null) {
                return true;
            }
            if (this.control.getMissingStrategy().shouldStoreSingle(id)) {
                return true;
            }
        }
        if (placeholder.getSegment(1).equals("multi")) {
            if (this.pendingChecks != null) {
                this.pendingChecks.add(placeholder);
                return true;
            }
            id = placeholder.getSegment(2);
            if (this.control.getMultipleDockable(id) != null) {
                return true;
            }
            if (this.control.getMissingStrategy().shouldStoreMulti(id)) {
                return true;
            }
        }
        return false;
    }

    public void install(DockStation station) {
    }

    public void uninstall(DockStation station) {
    }
}

