/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.server;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeConverterFactory;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;

public class PropertyHandlerMapping
extends AbstractReflectiveHandlerMapping {
    public PropertyHandlerMapping(ClassLoader pClassLoader, URL pURL, TypeConverterFactory pTypeConverterFactory, boolean pInstanceIsStateless) throws IOException, XmlRpcException {
        super(pTypeConverterFactory, pInstanceIsStateless);
        this.handlerMap = this.load(pClassLoader, pURL);
    }

    public PropertyHandlerMapping(ClassLoader pClassLoader, String pResource, TypeConverterFactory pTypeConverterFactory, boolean pInstanceIsStateless) throws IOException, XmlRpcException {
        this(pClassLoader, PropertyHandlerMapping.asURL(pClassLoader, pResource), pTypeConverterFactory, pInstanceIsStateless);
    }

    private static URL asURL(ClassLoader pClassLoader, String pResource) throws IOException {
        URL url = pClassLoader.getResource(pResource);
        if (url == null) {
            throw new IOException("Unable to locate resource " + pResource);
        }
        return url;
    }

    private Map load(ClassLoader pClassLoader, URL pURL) throws IOException, XmlRpcException {
        HashMap map = new HashMap();
        Properties props = new Properties();
        props.load(pURL.openStream());
        Iterator iter = ((Hashtable)props).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Class c = this.newHandlerClass(pClassLoader, value);
            this.registerPublicMethods(map, key, c);
        }
        return map;
    }

    protected Class newHandlerClass(ClassLoader pClassLoader, String pClassName) throws XmlRpcException {
        Class<?> c;
        try {
            c = pClassLoader.loadClass(pClassName);
        }
        catch (ClassNotFoundException e) {
            throw new XmlRpcException("Unable to load class: " + pClassName, (Throwable)e);
        }
        if (c == null) {
            throw new XmlRpcException(0, "Loading class " + pClassName + " returned null.");
        }
        return c;
    }
}

