/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.tool.CodeGenUtil;
import org.apache.xmlbeans.impl.tool.CommandLine;
import org.w3.x2001.xmlSchema.FormChoice;
import org.w3.x2001.xmlSchema.IncludeDocument;
import org.w3.x2001.xmlSchema.NamedAttributeGroup;
import org.w3.x2001.xmlSchema.NamedGroup;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.w3.x2001.xmlSchema.TopLevelAttribute;
import org.w3.x2001.xmlSchema.TopLevelComplexType;
import org.w3.x2001.xmlSchema.TopLevelElement;
import org.w3.x2001.xmlSchema.TopLevelSimpleType;

public class FactorImports {
    public static void main(String[] args) throws Exception {
        File outputFile;
        String out;
        CommandLine cl = new CommandLine(args, Arrays.asList("import", "out"));
        if (cl.getOpt("license") != null) {
            CommandLine.printLicense();
            System.exit(0);
            return;
        }
        args = cl.args();
        if (args.length != 1) {
            System.out.println("Refactors a directory of .xsd files to remove name conflicts");
            System.out.println("Usage:");
            System.out.println("sfactor [-import common.xsd] [-out outputdir] inputdir");
            System.out.println(" where inputdir is a directory containing .xsd files");
            System.out.println(" and outputdir is a directory into which new xsd files,");
            System.out.println(" plus a commonly imported common.xsd, is placed.");
            System.out.println(" -license prints license information");
            System.exit(0);
            return;
        }
        String commonName = cl.getOpt("import");
        if (commonName == null) {
            commonName = "common.xsd";
        }
        if ((out = cl.getOpt("out")) == null) {
            System.out.println("Using output directory 'out'");
            out = "out";
        }
        File outdir = new File(out);
        File basedir = new File(args[0]);
        File[] files = cl.getFiles();
        HashMap<SchemaDocument, File> schemaDocs = new HashMap<SchemaDocument, File>();
        HashSet elementNames = new HashSet();
        HashSet attributeNames = new HashSet();
        HashSet typeNames = new HashSet();
        HashSet modelGroupNames = new HashSet();
        HashSet attrGroupNames = new HashSet();
        HashSet dupeElementNames = new HashSet();
        HashSet dupeAttributeNames = new HashSet();
        HashSet dupeTypeNames = new HashSet();
        HashSet dupeModelGroupNames = new HashSet();
        HashSet dupeAttrGroupNames = new HashSet();
        HashSet dupeNamespaces = new HashSet();
        int i = 0;
        while (i < files.length) {
            try {
                String targetNamespace;
                SchemaDocument doc = SchemaDocument.Factory.parse(files[i]);
                schemaDocs.put(doc, files[i]);
                if (doc.getSchema().sizeOfImportArray() > 0 || doc.getSchema().sizeOfIncludeArray() > 0) {
                    System.out.println("warning: " + files[i] + " contains imports or includes that are being ignored.");
                }
                if ((targetNamespace = doc.getSchema().getTargetNamespace()) == null) {
                    targetNamespace = "";
                }
                TopLevelComplexType[] ct = doc.getSchema().getComplexTypeArray();
                int j = 0;
                while (j < ct.length) {
                    FactorImports.noteName(ct[j].getName(), targetNamespace, typeNames, dupeTypeNames, dupeNamespaces);
                    ++j;
                }
                TopLevelSimpleType[] st = doc.getSchema().getSimpleTypeArray();
                int j2 = 0;
                while (j2 < st.length) {
                    FactorImports.noteName(st[j2].getName(), targetNamespace, typeNames, dupeTypeNames, dupeNamespaces);
                    ++j2;
                }
                TopLevelElement[] el = doc.getSchema().getElementArray();
                int j3 = 0;
                while (j3 < el.length) {
                    FactorImports.noteName(el[j3].getName(), targetNamespace, elementNames, dupeElementNames, dupeNamespaces);
                    ++j3;
                }
                TopLevelAttribute[] at = doc.getSchema().getAttributeArray();
                int j4 = 0;
                while (j4 < at.length) {
                    FactorImports.noteName(at[j4].getName(), targetNamespace, attributeNames, dupeAttributeNames, dupeNamespaces);
                    ++j4;
                }
                NamedGroup[] gr = doc.getSchema().getGroupArray();
                int j5 = 0;
                while (j5 < gr.length) {
                    FactorImports.noteName(gr[j5].getName(), targetNamespace, modelGroupNames, dupeModelGroupNames, dupeNamespaces);
                    ++j5;
                }
                NamedAttributeGroup[] ag = doc.getSchema().getAttributeGroupArray();
                int j6 = 0;
                while (j6 < ag.length) {
                    FactorImports.noteName(ag[j6].getName(), targetNamespace, attrGroupNames, dupeAttrGroupNames, dupeNamespaces);
                    ++j6;
                }
            }
            catch (XmlException e) {
                System.out.println("warning: " + files[i] + " is not a schema file - " + e.getError().toString());
            }
            catch (IOException e) {
                System.err.println("Unable to load " + files[i] + " - " + e.getMessage());
                System.exit(1);
                return;
            }
            ++i;
        }
        if (schemaDocs.size() == 0) {
            System.out.println("No schema files found.");
            System.exit(0);
            return;
        }
        if (dupeTypeNames.size() + dupeElementNames.size() + dupeAttributeNames.size() + dupeModelGroupNames.size() + dupeAttrGroupNames.size() == 0) {
            System.out.println("No duplicate names found.");
            System.exit(0);
            return;
        }
        HashMap<String, SchemaDocument> commonDocs = new HashMap<String, SchemaDocument>();
        HashMap<SchemaDocument, File> commonFiles = new HashMap<SchemaDocument, File>();
        int count = dupeNamespaces.size() == 1 ? 0 : 1;
        Iterator i2 = dupeNamespaces.iterator();
        while (i2.hasNext()) {
            String namespace = (String)i2.next();
            SchemaDocument commonDoc = SchemaDocument.Factory.parse("<xs:schema xmlns:xs='http://www.w3.org/2001/XMLSchema'/>");
            if (namespace.length() > 0) {
                commonDoc.getSchema().setTargetNamespace(namespace);
            }
            commonDoc.getSchema().setElementFormDefault(FormChoice.QUALIFIED);
            commonDocs.put(namespace, commonDoc);
            commonFiles.put(commonDoc, FactorImports.commonFileFor(commonName, namespace, count++, outdir));
        }
        Iterator i3 = schemaDocs.keySet().iterator();
        while (i3.hasNext()) {
            SchemaDocument doc = (SchemaDocument)i3.next();
            String targetNamespace = doc.getSchema().getTargetNamespace();
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            SchemaDocument commonDoc = (SchemaDocument)commonDocs.get(targetNamespace);
            boolean needImport = false;
            TopLevelComplexType[] ct = doc.getSchema().getComplexTypeArray();
            int j = ct.length - 1;
            while (j >= 0) {
                if (FactorImports.isDuplicate(ct[j].getName(), targetNamespace, dupeTypeNames)) {
                    if (FactorImports.isFirstDuplicate(ct[j].getName(), targetNamespace, typeNames, dupeTypeNames)) {
                        commonDoc.getSchema().addNewComplexType().set(ct[j]);
                    }
                    needImport = true;
                    doc.getSchema().removeComplexType(j);
                }
                --j;
            }
            TopLevelSimpleType[] st = doc.getSchema().getSimpleTypeArray();
            int j7 = 0;
            while (j7 < st.length) {
                if (FactorImports.isDuplicate(st[j7].getName(), targetNamespace, dupeTypeNames)) {
                    if (FactorImports.isFirstDuplicate(st[j7].getName(), targetNamespace, typeNames, dupeTypeNames)) {
                        commonDoc.getSchema().addNewSimpleType().set(st[j7]);
                    }
                    needImport = true;
                    doc.getSchema().removeSimpleType(j7);
                }
                ++j7;
            }
            TopLevelElement[] el = doc.getSchema().getElementArray();
            int j8 = 0;
            while (j8 < el.length) {
                if (FactorImports.isDuplicate(el[j8].getName(), targetNamespace, dupeElementNames)) {
                    if (FactorImports.isFirstDuplicate(el[j8].getName(), targetNamespace, elementNames, dupeElementNames)) {
                        commonDoc.getSchema().addNewElement().set(el[j8]);
                    }
                    needImport = true;
                    doc.getSchema().removeElement(j8);
                }
                ++j8;
            }
            TopLevelAttribute[] at = doc.getSchema().getAttributeArray();
            int j9 = 0;
            while (j9 < at.length) {
                if (FactorImports.isDuplicate(at[j9].getName(), targetNamespace, dupeAttributeNames)) {
                    if (FactorImports.isFirstDuplicate(at[j9].getName(), targetNamespace, attributeNames, dupeAttributeNames)) {
                        commonDoc.getSchema().addNewElement().set(at[j9]);
                    }
                    needImport = true;
                    doc.getSchema().removeElement(j9);
                }
                ++j9;
            }
            NamedGroup[] gr = doc.getSchema().getGroupArray();
            int j10 = 0;
            while (j10 < gr.length) {
                if (FactorImports.isDuplicate(gr[j10].getName(), targetNamespace, dupeModelGroupNames)) {
                    if (FactorImports.isFirstDuplicate(gr[j10].getName(), targetNamespace, modelGroupNames, dupeModelGroupNames)) {
                        commonDoc.getSchema().addNewElement().set(gr[j10]);
                    }
                    needImport = true;
                    doc.getSchema().removeElement(j10);
                }
                ++j10;
            }
            NamedAttributeGroup[] ag = doc.getSchema().getAttributeGroupArray();
            int j11 = 0;
            while (j11 < ag.length) {
                if (FactorImports.isDuplicate(ag[j11].getName(), targetNamespace, dupeAttrGroupNames)) {
                    if (FactorImports.isFirstDuplicate(ag[j11].getName(), targetNamespace, attrGroupNames, dupeAttrGroupNames)) {
                        commonDoc.getSchema().addNewElement().set(ag[j11]);
                    }
                    needImport = true;
                    doc.getSchema().removeElement(j11);
                }
                ++j11;
            }
            if (!needImport) continue;
            IncludeDocument.Include newInclude = doc.getSchema().addNewInclude();
            File inputFile = (File)schemaDocs.get(doc);
            File outputFile2 = FactorImports.outputFileFor(inputFile, basedir, outdir);
            File commonFile = (File)commonFiles.get(commonDoc);
            if (targetNamespace == null) continue;
            newInclude.setSchemaLocation(FactorImports.relativeURIFor(outputFile2, commonFile));
        }
        if (!outdir.isDirectory() && !outdir.mkdirs()) {
            System.err.println("Unable to makedir " + outdir);
            System.exit(1);
            return;
        }
        Iterator i4 = schemaDocs.keySet().iterator();
        while (i4.hasNext()) {
            SchemaDocument doc = (SchemaDocument)i4.next();
            File inputFile = (File)schemaDocs.get(doc);
            outputFile = FactorImports.outputFileFor(inputFile, basedir, outdir);
            if (outputFile == null) {
                System.out.println("Cannot copy " + inputFile);
                continue;
            }
            doc.save(outputFile, new XmlOptions().setSavePrettyPrint().setSaveAggresiveNamespaces());
        }
        Iterator i5 = commonFiles.keySet().iterator();
        while (i5.hasNext()) {
            SchemaDocument doc = (SchemaDocument)i5.next();
            outputFile = (File)commonFiles.get(doc);
            doc.save(outputFile, new XmlOptions().setSavePrettyPrint().setSaveAggresiveNamespaces());
        }
    }

    private static File outputFileFor(File file, File baseDir, File outdir) {
        URI abs;
        URI base = baseDir.getAbsoluteFile().toURI();
        URI rel = base.relativize(abs = file.getAbsoluteFile().toURI());
        if (rel.isAbsolute()) {
            System.out.println("Cannot relativize " + file);
            return null;
        }
        URI outbase = outdir.toURI();
        URI out = CodeGenUtil.resolve(outbase, rel);
        return new File(out);
    }

    private static URI commonAncestor(URI first, URI second) {
        String firstStr = first.toString();
        String secondStr = second.toString();
        int len = firstStr.length();
        if (secondStr.length() < len) {
            len = secondStr.length();
        }
        int i = 0;
        while (i < len) {
            if (firstStr.charAt(i) != secondStr.charAt(i)) break;
            ++i;
        }
        if (--i >= 0) {
            i = firstStr.lastIndexOf(47, i);
        }
        if (i < 0) {
            return null;
        }
        try {
            return new URI(firstStr.substring(0, i));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static String relativeURIFor(File source, File target) {
        URI abs;
        URI base = source.getAbsoluteFile().toURI();
        URI commonBase = FactorImports.commonAncestor(base, abs = target.getAbsoluteFile().toURI());
        if (commonBase == null) {
            return abs.toString();
        }
        URI baserel = commonBase.relativize(base);
        URI targetrel = commonBase.relativize(abs);
        if (baserel.isAbsolute() || targetrel.isAbsolute()) {
            return abs.toString();
        }
        String prefix = "";
        String sourceRel = baserel.toString();
        int i = 0;
        while (i < sourceRel.length()) {
            if ((i = sourceRel.indexOf(47, i)) < 0) break;
            prefix = prefix + "../";
            ++i;
        }
        return prefix + targetrel.toString();
    }

    private static File commonFileFor(String commonName, String namespace, int i, File outdir) {
        String name = commonName;
        if (i > 0) {
            int index = commonName.lastIndexOf(46);
            if (index < 0) {
                index = commonName.length();
            }
            name = commonName.substring(0, index) + i + commonName.substring(index);
        }
        return new File(outdir, name);
    }

    private static void noteName(String name, String targetNamespace, Set seen, Set dupes, Set dupeNamespaces) {
        if (name == null) {
            return;
        }
        QName qName = new QName(targetNamespace, name);
        if (seen.contains(qName)) {
            dupes.add(qName);
            dupeNamespaces.add(targetNamespace);
        } else {
            seen.add(qName);
        }
    }

    private static boolean isFirstDuplicate(String name, String targetNamespace, Set notseen, Set dupes) {
        if (name == null) {
            return false;
        }
        QName qName = new QName(targetNamespace, name);
        if (dupes.contains(qName) && notseen.contains(qName)) {
            notseen.remove(qName);
            return true;
        }
        return false;
    }

    private static boolean isDuplicate(String name, String targetNamespace, Set dupes) {
        if (name == null) {
            return false;
        }
        QName qName = new QName(targetNamespace, name);
        return dupes.contains(qName);
    }
}

