/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.java.message;

import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.java.message.MessageReader;
import org.codehaus.xfire.util.DateUtils;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class LiteralReader
implements MessageReader {
    private DepthXMLStreamReader root;
    private String value;
    private String localName;
    private QName name;
    private boolean hasCheckedChildren = false;
    private boolean hasChildren = false;
    private boolean hasFoundText = false;
    int depth;

    public LiteralReader(DepthXMLStreamReader root) {
        this.root = root;
        this.localName = root.getLocalName();
        this.name = root.getName();
        this.depth = root.getDepth();
    }

    public LiteralReader(XMLStreamReader reader) {
        this.root = new DepthXMLStreamReader(reader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.depth = this.root.getDepth();
    }

    public String getValue() {
        if (!this.hasFoundText) {
            this.findValue();
        }
        return this.value;
    }

    private void findValue() {
        while (!this.hasFoundText && this.checkHasMoreChildReaders()) {
        }
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.getValue());
    }

    public Date getValueAsDate() {
        if (this.getValue() == null) {
            return null;
        }
        return DateUtils.parseDate((String)this.getValue());
    }

    public Date getValueAsDateTime() {
        if (this.getValue() == null) {
            return null;
        }
        return DateUtils.parseDateTime((String)this.getValue());
    }

    public Calendar getValueAsCalendar() {
        if (this.getValue() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDateTime((String)this.getValue()));
        return calendar;
    }

    public long getValueAsLong() {
        return Long.parseLong(this.getValue());
    }

    public double getValueAsDouble() {
        return Double.parseDouble(this.getValue());
    }

    public float getValueAsFloat() {
        return Float.parseFloat(this.getValue());
    }

    public boolean getValueAsBoolean() {
        return Boolean.valueOf(this.getValue());
    }

    public boolean hasMoreChildReaders() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        return this.hasChildren;
    }

    private boolean checkHasMoreChildReaders() {
        try {
            int event = this.root.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        if (this.root.getDepth() <= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = true;
                        return true;
                    }
                    case 2: {
                        if (this.root.getDepth() > this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        this.root.next();
                        return false;
                    }
                    case 4: {
                        this.value = this.root.getText();
                        this.hasFoundText = true;
                        break;
                    }
                    case 8: {
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        return false;
                    }
                }
                event = this.root.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error parsing document.", (Throwable)e);
        }
    }

    public MessageReader getNextChildReader() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        if (!this.hasChildren) {
            return null;
        }
        this.hasCheckedChildren = false;
        return new LiteralReader(this.root);
    }

    public QName getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }
}

