/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.builder;

import java.util.Collection;
import java.util.Iterator;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.codehaus.xfire.service.object.ObjectService;
import org.codehaus.xfire.service.object.Operation;
import org.codehaus.xfire.service.object.Parameter;
import org.codehaus.xfire.type.Type;
import org.codehaus.xfire.wsdl11.builder.AbstractJavaWSDL;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class RPCEncodedWSDL
extends AbstractJavaWSDL {
    public RPCEncodedWSDL(ObjectService service, Collection transports) throws WSDLException {
        super(service, transports);
    }

    protected void createOutputParts(Message res, Operation op) {
        this.writeParametersSchema(res, op.getOutParameters());
    }

    protected void createInputParts(Message req, Operation op) {
        this.writeParametersSchema(req, op.getInParameters());
    }

    protected void writeParametersSchema(Message message, Collection params) {
        ObjectService service = (ObjectService)this.getService();
        Iterator itr = params.iterator();
        while (itr.hasNext()) {
            Parameter param = (Parameter)itr.next();
            Class clazz = param.getTypeClass();
            QName pName = param.getName();
            Type type = service.getTypeMapping().getType(clazz);
            this.addDependency(type);
            QName schemaType = type.getSchemaType();
            Part part = this.getDefinition().createPart();
            part.setName(pName.getLocalPart());
            if (type.isComplex()) {
                part.setElementName(pName);
                Element schemaEl = this.createSchemaType(service.getDefaultNamespace());
                Element element = schemaEl.addElement(this.elementQ);
                element.addAttribute("name", pName.getLocalPart());
                Namespace typeNS = this.getNamespace(schemaType.getNamespaceURI());
                this.addNamespace(typeNS.getPrefix(), typeNS.getURI());
                element.addAttribute("type", typeNS.getPrefix() + ":" + schemaType.getLocalPart());
            } else {
                part.setElementName(type.getSchemaType());
            }
            message.addPart(part);
        }
    }
}

