/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.message;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.message.MessageReader;
import org.codehaus.xfire.util.DateUtils;
import org.codehaus.xfire.util.DepthXMLStreamReader;

public class LiteralReader
implements MessageReader {
    private DepthXMLStreamReader root;
    private String value;
    private String localName;
    private QName name;
    private boolean hasCheckedChildren = false;
    private boolean hasChildren = false;
    private boolean hasFoundText = false;
    private String namespace;
    private int depth;

    public LiteralReader(DepthXMLStreamReader root) {
        this.root = root;
        this.localName = root.getLocalName();
        this.name = root.getName();
        this.namespace = root.getNamespaceURI();
        this.depth = root.getDepth();
    }

    public LiteralReader(XMLStreamReader reader) {
        this.root = new DepthXMLStreamReader(reader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.depth = this.root.getDepth();
    }

    public LiteralReader(InputStream is) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader xmlReader = factory.createXMLStreamReader(is);
        while (xmlReader.getEventType() != 1) {
            xmlReader.next();
        }
        this.root = new DepthXMLStreamReader(xmlReader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.depth = this.root.getDepth();
    }

    public String getValue() {
        while (!this.hasFoundText && this.checkHasMoreChildReaders()) {
        }
        return this.value;
    }

    public String getValue(String ns, String attr) {
        return this.root.getAttributeValue(ns, attr);
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.getValue());
    }

    public int getValueAsInt(String ns, String attr) {
        return Integer.parseInt(this.getValue(ns, attr));
    }

    public Date getValueAsDate() {
        if (this.getValue() == null) {
            return null;
        }
        return DateUtils.parseDate((String)this.getValue());
    }

    public Date getValueAsDate(String ns, String attr) {
        String value = this.getValue(ns, attr);
        if (value == null) {
            return null;
        }
        return DateUtils.parseDate((String)value);
    }

    public Date getValueAsDateTime() {
        if (this.getValue() == null) {
            return null;
        }
        return DateUtils.parseDateTime((String)this.getValue());
    }

    public Date getValueAsDateTime(String ns, String attr) {
        String value = this.getValue(ns, attr);
        if (value == null) {
            return null;
        }
        return DateUtils.parseDateTime((String)value);
    }

    public Calendar getValueAsCalendar() {
        if (this.getValue() == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDateTime((String)this.getValue()));
        return calendar;
    }

    public Calendar getValueAsCalendar(String ns, String attr) {
        String value = this.getValue(ns, attr);
        if (value == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.parseDateTime((String)this.getValue(ns, attr)));
        return calendar;
    }

    public long getValueAsLong() {
        return Long.parseLong(this.getValue());
    }

    public long getValueAsLong(String ns, String att) {
        return Long.parseLong(this.getValue(ns, att));
    }

    public double getValueAsDouble() {
        return Double.parseDouble(this.getValue());
    }

    public double getValueAsDouble(String ns, String attr) {
        return Double.parseDouble(this.getValue(ns, attr));
    }

    public float getValueAsFloat() {
        return Float.parseFloat(this.getValue());
    }

    public float getValueAsFloat(String ns, String attr) {
        return Float.parseFloat(this.getValue(ns, attr));
    }

    public boolean getValueAsBoolean() {
        return Boolean.valueOf(this.getValue());
    }

    public boolean getValueAsBoolean(String ns, String attr) {
        return Boolean.valueOf(this.getValue(ns, attr));
    }

    public boolean hasMoreChildReaders() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        return this.hasChildren;
    }

    private boolean checkHasMoreChildReaders() {
        try {
            int event = this.root.getEventType();
            while (true) {
                switch (event) {
                    case 1: {
                        if (this.root.getDepth() <= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = true;
                        return true;
                    }
                    case 2: {
                        if (this.root.getDepth() > this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        this.root.next();
                        return false;
                    }
                    case 4: {
                        this.value = this.root.getText();
                        this.hasFoundText = true;
                        break;
                    }
                    case 8: {
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        return false;
                    }
                }
                event = this.root.next();
            }
        }
        catch (XMLStreamException e) {
            throw new XFireRuntimeException("Error parsing document.", (Throwable)e);
        }
    }

    public MessageReader getNextChildReader() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        if (!this.hasChildren) {
            return null;
        }
        this.hasCheckedChildren = false;
        return new LiteralReader(this.root);
    }

    public QName getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.root;
    }
}

