/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Counter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected ParserWrapper.DocumentInfo fDocumentInfo;

    public void setDocumentInfo(ParserWrapper.DocumentInfo documentInfo) {
        this.fDocumentInfo = documentInfo;
    }

    public void count(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fElements = 0L;
                this.fAttributes = 0L;
                this.fCharacters = 0L;
                this.fIgnorableWhitespace = 0L;
                Document document = (Document)node;
                this.count(document.getDocumentElement());
                break;
            }
            case 1: {
                ++this.fElements;
                Object object = node.getAttributes();
                if (object != null) {
                    this.fAttributes += (long)object.getLength();
                }
            }
            case 5: {
                Object object = node.getFirstChild();
                while (object != null) {
                    this.count((Node)object);
                    object = object.getNextSibling();
                }
                break;
            }
            case 4: {
                this.fCharacters += (long)((Text)node).getLength();
                break;
            }
            case 3: {
                if (this.fDocumentInfo == null) break;
                Text text = (Text)node;
                int n = text.getLength();
                if (this.fDocumentInfo.isIgnorableWhitespace(text)) {
                    this.fIgnorableWhitespace += (long)n;
                    break;
                }
                this.fCharacters += (long)n;
            }
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, long l3, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(';');
        printWriter.print(l2);
        printWriter.print(';');
        printWriter.print(l3);
        printWriter.print(" ms (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        printWriter.println();
        printWriter.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        var1_1 = new Counter();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = 1;
        var5_5 = true;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = 0;
        while (var10_10 < var0.length) {
            block45: {
                var11_11 = var0[var10_10];
                if (!var11_11.startsWith("-")) ** GOTO lbl-1000
                var12_12 = var11_11.substring(1);
                if (var12_12.equals("p")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var13_21 = var0[var10_10];
                    try {
                        var3_3 = (ParserWrapper)Class.forName(var13_21).newInstance();
                    }
                    catch (Exception var14_23) {
                        var3_3 = null;
                        System.err.println("error: Unable to instantiate parser (" + var13_21 + ")");
                    }
                } else if (var12_12.equals("x")) {
                    if (++var10_10 == var0.length) {
                        System.err.println("error: Missing argument to -x option.");
                    } else {
                        var13_21 = var0[var10_10];
                        try {
                            var14_24 = Integer.parseInt(var13_21);
                            if (var14_24 < 1) {
                                System.err.println("error: Repetition must be at least 1.");
                                break block45;
                            }
                            var4_4 = var14_24;
                        }
                        catch (NumberFormatException var14_25) {
                            System.err.println("error: invalid number (" + var13_21 + ").");
                        }
                    }
                } else if (var12_12.equalsIgnoreCase("n")) {
                    var5_5 = var12_12.equals("n");
                } else if (var12_12.equalsIgnoreCase("v")) {
                    var6_6 = var12_12.equals("v");
                } else if (var12_12.equalsIgnoreCase("s")) {
                    var7_7 = var12_12.equals("s");
                } else if (var12_12.equalsIgnoreCase("f")) {
                    var8_8 = var12_12.equals("f");
                } else if (var12_12.equalsIgnoreCase("dv")) {
                    var9_9 = var12_12.equals("dv");
                } else if (var12_12.equals("h")) {
                    Counter.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception var12_13) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block45;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var5_5);
                    }
                    catch (SAXException var12_14) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var6_6);
                    }
                    catch (SAXException var12_15) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var7_7);
                    }
                    catch (SAXException var12_16) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var8_8);
                    }
                    catch (SAXException var12_17) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/dynamic", var9_9);
                    }
                    catch (SAXException var12_18) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        var12_19 = System.currentTimeMillis();
                        var14_26 = null;
                        var15_27 = 0;
                        while (var15_27 < var4_4) {
                            var14_26 = var3_3.parse(var11_11);
                            ++var15_27;
                        }
                        var16_28 = System.currentTimeMillis();
                        var18_29 = var16_28 - var12_19;
                        var20_30 = var3_3.getDocumentInfo();
                        var1_1.setDocumentInfo(var20_30);
                        var21_31 = System.currentTimeMillis();
                        var1_1.count((Node)var14_26);
                        var23_32 = System.currentTimeMillis();
                        var25_33 = var23_32 - var21_31;
                        var27_34 = System.currentTimeMillis();
                        var1_1.count((Node)var14_26);
                        var29_35 = System.currentTimeMillis();
                        var31_36 = var29_35 - var27_34;
                        var1_1.printResults(var2_2, var11_11, var18_29, var25_33, var31_36, var4_4);
                    }
                    catch (SAXParseException var12_20) {
                    }
                    catch (Exception var13_22) {
                        System.err.println("error: Parse error occurred - " + var13_22.getMessage());
                        var14_26 = var13_22;
                        if (var13_22 instanceof SAXException) {
                            var14_26 = ((SAXException)var13_22).getException();
                        }
                        if (var14_26 != null) {
                            var14_26.printStackTrace(System.err);
                        }
                        var13_22.printStackTrace(System.err);
                    }
                }
            }
            ++var10_10;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
    }
}

