/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.web;

import convex.peer.Server;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.model.CreateAccountResponse;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.UnauthorizedResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiResponse;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerAdminAPI
extends ABaseAPI {
    protected static final Logger log = LoggerFactory.getLogger((String)PeerAdminAPI.class.getName());
    public Server server;
    private static final String ROUTE = "/api/v1/";
    private HashSet<String> authorisedIPs = new HashSet<String>(Arrays.asList("127.0.0.1", "::1", "[0:0:0:0:0:0:0:1]"));

    public PeerAdminAPI(RESTServer restServer) {
        super(restServer);
        this.server = restServer.getServer();
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.post(prefix + "peer/shutdown", this::shutDown);
    }

    @OpenApi(path="/api/v1/peer/shutdown", versions={"peer-v1"}, methods={HttpMethod.POST}, operationId="shutdownPeer", tags={"Admin"}, summary="Shut down the current peer", responses={@OpenApiResponse(status="200", description="Peer shutdown initiated", content={@OpenApiContent(type="application/json", from=CreateAccountResponse.class)})})
    public void shutDown(Context ctx) {
        this.ensureLocalAdmin(ctx);
        log.warn("Server Shuttting down due to REST admin shutdown request");
        this.server.shutdown();
        ctx.result("Shutdown initiated.");
    }

    private void ensureLocalAdmin(Context ctx) {
        String ip = ctx.ip();
        if (this.authorisedIPs.contains(ip)) {
            return;
        }
        throw new UnauthorizedResponse("Can't performa admin actions from IP: " + ip);
    }
}

