/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.web;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.cpos.Block;
import convex.core.cpos.BlockResult;
import convex.core.cpos.Order;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Index;
import convex.core.data.MapEntry;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.prim.CVMLong;
import convex.core.lang.RT;
import convex.core.util.JSON;
import convex.core.util.Utils;
import convex.peer.Config;
import convex.peer.ConnectionManager;
import convex.peer.Server;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.api.McpAPI;
import convex.restapi.web.AWebSite;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.NotFoundResponse;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.CodeTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TextareaTag;
import j2html.tags.specialized.TrTag;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExplorerAPI
extends AWebSite {
    static final String ROUTE = "/explorer/";
    private static final AString KEY_NAME = Strings.create((String)"name");
    private static final AString KEY_TITLE = Strings.create((String)"title");
    private static final AString KEY_DESCRIPTION = Strings.create((String)"description");
    private static final AString KEY_INPUT_SCHEMA = Strings.create((String)"inputSchema");
    private static final AString KEY_OUTPUT_SCHEMA = Strings.create((String)"outputSchema");

    public ExplorerAPI(RESTServer restServer) {
        super(restServer);
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.get(prefix, this::showExplorer);
        app.get(prefix + "blocks", this::showBlocks);
        app.get(prefix + "blocks/{blockNum}", this::showBlock);
        app.get(prefix + "blocks/{blockNum}/txs/{txNum}", this::showTransaction);
        app.get(prefix + "states", this::showStates);
        app.get(prefix + "states/{position}", this::showStatePage);
        app.get(prefix + "accounts", this::showAccounts);
        app.get(prefix + "accounts/{accountNum}", this::showAccount);
        app.get(prefix + "peers", this::showPeers);
        app.get(prefix + "peers/{peerKey}", this::showPeerDetail);
        app.get(prefix + "connections", this::showConnections);
        app.get(prefix + "mcp", this::showMcp);
        app.get(prefix + "mcp/tools/{toolName}", this::showMcpTool);
        app.get(prefix + "repl", this::showRepl);
        app.post(prefix + "search", this::handleSearch);
    }

    public void showExplorer(Context ctx) {
        this.returnPage(ctx, "Peer Explorer", (String[][])null, new DomContent[]{this.searchBox(), ((DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"Blocks").withHref("/explorer/blocks")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"Browse blocks in the peer's consensus order, view details and transactions.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"Accounts").withHref("/explorer/accounts")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"Explore accounts in the latest consensus.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"Peers").withHref("/explorer/peers")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"Examine peers on the current network, including stakes and activity.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"Connections").withHref("/explorer/connections")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"Inspect outbound peer connections maintained by this server.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"MCP").withHref("/explorer/mcp")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"View Model Context Protocol endpoint details and available tools.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"States").withHref("/explorer/states")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"View historical consensus states.")}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((DomContent[])new DomContent[]{((ATag)TagCreator.a((String)"REPL").withHref("/explorer/repl")).withStyle("font-weight:600;font-size:1.1em;")}), TagCreator.p((String)"Interactive Read-Eval-Print Loop for executing Convex Lisp code.")})}).withClass("grid")).withStyle("align-items: stretch;"), TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Discord Chat"), TagCreator.rawHtml((String)"<iframe src=\"https://discord.com/widget?id=734599663713386617&theme=dark\" width=\"100%\" height=\"300\" allowtransparency=\"true\" frameborder=\"0\" sandbox=\"allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts\"></iframe>")})})});
    }

    public void showConnections(Context ctx) {
        InetSocketAddress localAddress;
        TdTag localPeerCell;
        PeerStatus localStatus;
        Integer targetConnections;
        Server s = this.restServer.getServer();
        if (s == null) {
            this.returnPage(ctx, "Connections", new String[][]{{"Explorer", ROUTE}, {"Connections", null}}, new DomContent[]{TagCreator.p((String)"No local peer server is configured.")});
            return;
        }
        ConnectionManager cm = s.getConnectionManager();
        HashMap connectionMap = new HashMap(cm.getConnections());
        try {
            targetConnections = Utils.toInt(s.getConfig().get(Keywords.OUTGOING_CONNECTIONS));
        }
        catch (IllegalArgumentException ex) {
            targetConnections = null;
        }
        if (targetConnections == null) {
            targetConnections = Config.DEFAULT_OUTGOING_CONNECTION_COUNT;
        }
        State state = s.getPeer().getConsensusState();
        ArrayList entries = new ArrayList(connectionMap.entrySet());
        entries.sort(Comparator.comparing(e -> ((AccountKey)e.getKey()).toHexString()));
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        AccountKey localPeerKey = s.getPeerKey();
        PeerStatus peerStatus = localStatus = localPeerKey != null ? state.getPeer(localPeerKey) : null;
        if (localPeerKey != null) {
            String localLink = "/explorer/peers/" + localPeerKey.toHexString();
            localPeerCell = TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)localPeerKey)}).withHref(localLink)});
        } else {
            localPeerCell = TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)"-")});
        }
        CodeTag localStake = localStatus != null ? this.showBalance(localStatus.getBalance()) : TagCreator.code((String)"-");
        CodeTag localAdvertised = localStatus != null && localStatus.getHostname() != null ? TagCreator.code((String)localStatus.getHostname().toString()) : TagCreator.code((String)"-");
        try {
            localAddress = s.getHostAddress();
        }
        catch (Exception e2) {
            localAddress = null;
        }
        Object localHost = "-";
        if (localAddress != null) {
            String hostPart = localAddress.getHostString();
            if (hostPart == null || hostPart.isBlank()) {
                hostPart = localAddress.getAddress() != null ? localAddress.getAddress().getHostAddress() : localAddress.toString();
            }
            localHost = localAddress.getPort() >= 0 ? hostPart + ":" + localAddress.getPort() : hostPart;
        }
        String localType = s.getClass().getSimpleName();
        rows.add(new DomContent[]{localPeerCell, TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)"Local")}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)localHost)}), TagCreator.td((DomContent[])new DomContent[]{localAdvertised}), TagCreator.td((DomContent[])new DomContent[]{localStake}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)localType)})});
        for (Map.Entry entry : entries) {
            AccountKey peerKey = (AccountKey)entry.getKey();
            if (localPeerKey != null && localPeerKey.equals(peerKey)) continue;
            Convex connection = (Convex)entry.getValue();
            InetSocketAddress remoteAddress = connection != null ? connection.getHostAddress() : null;
            Object remoteHost = "-";
            if (remoteAddress != null) {
                String hostPart = remoteAddress.getHostString();
                if (hostPart == null || hostPart.isBlank()) {
                    hostPart = remoteAddress.getAddress() != null ? remoteAddress.getAddress().getHostAddress() : remoteAddress.toString();
                }
                remoteHost = remoteAddress.getPort() >= 0 ? hostPart + ":" + remoteAddress.getPort() : hostPart;
            }
            boolean connected = connection != null && connection.isConnected();
            PeerStatus peerStatus2 = state.getPeer(peerKey);
            CodeTag stakeCell = peerStatus2 != null ? this.showBalance(peerStatus2.getBalance()) : TagCreator.code((String)"-");
            CodeTag advertisedHost = peerStatus2 != null && peerStatus2.getHostname() != null ? TagCreator.code((String)peerStatus2.getHostname().toString()) : TagCreator.code((String)"-");
            String connType = connection != null ? connection.getClass().getSimpleName() : "-";
            String peerLink = "/explorer/peers/" + peerKey.toHexString();
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)peerKey)}).withHref(peerLink)}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)(connected ? "Connected" : "Closed"))}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)remoteHost)}), TagCreator.td((DomContent[])new DomContent[]{advertisedHost}), TagCreator.td((DomContent[])new DomContent[]{stakeCell}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)connType)})});
        }
        TableTag tableContent = TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Peer Key"), TagCreator.th((String)"Status"), TagCreator.th((String)"Remote Address"), TagCreator.th((String)"Advertised Host"), TagCreator.th((String)"Total Stake"), TagCreator.th((String)"Connection Type")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})});
        this.returnPage(ctx, "Connections", new String[][]{{"Explorer", ROUTE}, {"Connections", null}}, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{TagCreator.p((String)("Active connections: " + connectionMap.size())), TagCreator.p((String)("Target connections: " + targetConnections))}), TagCreator.article((DomContent[])new DomContent[]{tableContent})});
    }

    public void showMcp(Context ctx) {
        McpAPI mcp = this.restServer.getMcpAPI();
        if (mcp == null) {
            this.returnPage(ctx, "MCP", new String[][]{{"Explorer", ROUTE}, {"MCP", null}}, new DomContent[]{TagCreator.p((String)"MCP API is not configured on this server.")});
            return;
        }
        String endpointUrl = ABaseAPI.getExternalBaseUrl(ctx, "/mcp");
        AMap<AString, ACell> serverInfo = mcp.getServerInfo();
        ArrayList<DomContent> infoRows = new ArrayList<DomContent>();
        if (serverInfo != null) {
            long count = serverInfo.count();
            int i = 0;
            while ((long)i < count) {
                MapEntry entry = serverInfo.entryAt((long)i);
                infoRows.add(this.row(((AString)entry.getKey()).toString(), (DomContent)this.showCVX(entry.getValue()), ""));
                ++i;
            }
        }
        TableTag infoTable = TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), TagCreator.tbody((DomContent[])new DomContent[]{infoRows.isEmpty() ? TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"-"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)"nil")}), TagCreator.td((String)"")}) : TagCreator.each(infoRows, r -> r)})});
        AVector<AMap<AString, ACell>> toolMetadata = mcp.getToolMetadata();
        ArrayList<DomContent[]> toolRows = new ArrayList<DomContent[]>();
        if (toolMetadata != null) {
            long toolCount = toolMetadata.count();
            int i = 0;
            while ((long)i < toolCount) {
                AMap metadata = (AMap)toolMetadata.get(i);
                AString nameCell = RT.ensureString((ACell)metadata.get((ACell)KEY_NAME));
                AString titleCell = RT.ensureString((ACell)metadata.get((ACell)KEY_TITLE));
                AString descriptionCell = RT.ensureString((ACell)metadata.get((ACell)KEY_DESCRIPTION));
                String toolName = nameCell != null ? nameCell.toString() : "unknown";
                String toolTitle = titleCell != null ? titleCell.toString() : toolName;
                String description = descriptionCell != null ? descriptionCell.toString() : "";
                String toolLink = "/explorer/mcp/tools/" + toolName;
                toolRows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)toolTitle).withHref(toolLink)}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)toolName)}), TagCreator.td((DomContent[])new DomContent[]{description == null || description.isBlank() ? TagCreator.em((String)"No description") : TagCreator.text((String)description)})});
                ++i;
            }
        }
        TableTag toolsTable = TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Title"), TagCreator.th((String)"Name"), TagCreator.th((String)"Description")})}), TagCreator.tbody((DomContent[])new DomContent[]{toolRows.isEmpty() ? TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.em((String)"No tools registered")}).attr("colspan", (Object)"3")}) : TagCreator.each(toolRows, row -> TagCreator.tr((DomContent[])row))})});
        this.returnPage(ctx, "Model Context Protocol", new String[][]{{"Explorer", ROUTE}, {"MCP", null}}, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{TagCreator.h6((String)"MCP Endpoint"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"POST requests to "), TagCreator.code((String)endpointUrl)}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"This peer provides MCP JSON-RPC access for LLMs and AI tools")})}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.h6((String)"MCP Server Info"), infoTable}), TagCreator.article((DomContent[])new DomContent[]{TagCreator.h6((String)"Registered Tools"), toolsTable})});
    }

    public void showMcpTool(Context ctx) {
        McpAPI mcp = this.restServer.getMcpAPI();
        if (mcp == null) {
            this.returnPage(ctx, "MCP Tool", new String[][]{{"Explorer", ROUTE}, {"MCP", "/explorer/mcp"}, {"Tool", null}}, new DomContent[]{TagCreator.p((String)"MCP API is not configured on this server.")});
            return;
        }
        String toolNameParam = ctx.pathParam("toolName");
        AVector<AMap<AString, ACell>> toolMetadata = mcp.getToolMetadata();
        if (toolMetadata == null) {
            throw new NotFoundResponse("No tools available");
        }
        AMap metadata = null;
        long toolCount = toolMetadata.count();
        int i = 0;
        while ((long)i < toolCount) {
            AMap entry = (AMap)toolMetadata.get(i);
            AString nameCell = RT.ensureString((ACell)entry.get((ACell)KEY_NAME));
            if (nameCell != null && toolNameParam.equals(nameCell.toString())) {
                metadata = entry;
                break;
            }
            ++i;
        }
        if (metadata == null) {
            throw new NotFoundResponse("Unknown MCP tool: " + toolNameParam);
        }
        AString titleCell = RT.ensureString((ACell)metadata.get((ACell)KEY_TITLE));
        AString descriptionCell = RT.ensureString((ACell)metadata.get((ACell)KEY_DESCRIPTION));
        String toolTitle = titleCell != null ? titleCell.toString() : toolNameParam;
        String description = descriptionCell != null ? descriptionCell.toString() : null;
        ACell inputSchema = metadata.get((ACell)KEY_INPUT_SCHEMA);
        ACell outputSchema = metadata.get((ACell)KEY_OUTPUT_SCHEMA);
        String[][] breadcrumbs = new String[][]{{"Explorer", ROUTE}, {"MCP", "/explorer/mcp"}, {toolNameParam, null}};
        TableTag toolMetadataTable = TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Name"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)toolNameParam)})}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Title"), TagCreator.td((String)toolTitle)}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Description"), TagCreator.td((DomContent[])new DomContent[]{description == null || description.isBlank() ? TagCreator.em((String)"No description provided") : TagCreator.text((String)description)})})})});
        DivTag schemaSection = TagCreator.div((DomContent[])new DomContent[]{inputSchema != null ? TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Input Schema"), ExplorerAPI.preCode(JSON.toStringPretty((Object)inputSchema))}) : TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"No input schema defined")}), outputSchema != null ? TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Output Schema"), ExplorerAPI.preCode(JSON.toStringPretty((Object)outputSchema))}) : TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"No output schema defined")})});
        ACell examples = metadata.get((ACell)Strings.create((String)"examples"));
        DivTag examplesSection = examples != null ? TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Examples"), ExplorerAPI.preCode(JSON.toStringPretty((Object)examples))}) : TagCreator.div();
        this.returnPage(ctx, toolTitle, breadcrumbs, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{toolMetadataTable}), TagCreator.article((DomContent[])new DomContent[]{schemaSection}), TagCreator.article((DomContent[])new DomContent[]{examplesSection})});
    }

    public void showStates(Context ctx) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        long nstates = peer.getStatePosition() + 1L;
        long[] range = this.getPaginationRange(ctx, nstates);
        long start = range[0];
        long end = range[1];
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = start; i < end; ++i) {
            State state = i == 0L ? peer.getGenesisState() : peer.getBlockResult(i - 1L).getState();
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)Long.toString(i)).withHref("/explorer/states/" + i)}), TagCreator.td((DomContent[])new DomContent[]{this.showStateID(state, i)}), TagCreator.td((DomContent[])new DomContent[]{this.timestamp(state.getTimestamp().longValue())})});
        }
        this.returnPage(ctx, "States,", new String[][]{{"Explorer", ROUTE}, {"States", null}}, new DomContent[]{TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Position"), TagCreator.th((String)"State Hash"), TagCreator.th((String)"Timestamp")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})});
    }

    public void showStatePage(Context ctx) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        long pos = Long.parseLong(ctx.pathParam("position"));
        long nstates = peer.getStatePosition() + 1L;
        if (pos < 0L || pos >= nstates) {
            throw new NotFoundResponse("State position out of range: " + pos);
        }
        State state = pos == 0L ? peer.getGenesisState() : peer.getBlockResult(pos - 1L).getState();
        this.returnPage(ctx, "State #" + pos, new String[][]{{"Explorer", ROUTE}, {"States", "/explorer/states"}, {Long.toString(pos), null}}, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{pos == 0L ? TagCreator.h5((String)"Genesis state") : TagCreator.h5((DomContent[])new DomContent[]{TagCreator.text((String)"State after "), TagCreator.a((String)("block " + (pos - 1L))).withHref("/explorer/blocks/" + (pos - 1L))}), this.makeNavigationLinks("/explorer/states", pos, nstates, "State"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Hash"), TagCreator.td((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)state.getHash(), 64)}), TagCreator.td((String)"State hash")}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Timestamp"), TagCreator.td((DomContent[])new DomContent[]{this.timestamp(state.getTimestamp().longValue())}), TagCreator.td((String)"State timestamp (UTC)")}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Accounts"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)Long.toString(state.getAccounts().count()))}), TagCreator.td((String)"Account count at this state")})})})})});
    }

    public void showAccounts(Context ctx) {
        Server s = this.restServer.getServer();
        State state = s.getState();
        AVector accounts = state.getAccounts();
        long naccounts = accounts.count();
        long[] range = this.getPaginationRange(ctx, naccounts);
        long start = range[0];
        long limit = range[2];
        DomContent paginationLinks = this.makePaginationLinks(ctx, "/explorer/accounts", start, limit, naccounts);
        this.returnPage(ctx, "Accounts", new String[][]{{"Explorer", ROUTE}, {"Accounts", null}}, new DomContent[]{paginationLinks, this.buildAccountsTable(ctx, (AVector<AccountStatus>)accounts, range)});
    }

    public TableTag buildAccountsTable(Context ctx, AVector<AccountStatus> accounts, long[] range) {
        long end = range[1];
        long start = range[0];
        if (end - start > 100L) {
            throw new BadRequestResponse("Too many elements requested");
        }
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = start; i < end; ++i) {
            Address address = Address.create((long)i);
            AccountStatus account = (AccountStatus)accounts.get(i);
            String accountLink = "/explorer/accounts/" + i;
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)address.toString()).withHref(accountLink)}), TagCreator.td((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)account.getAccountKey())}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{this.showBalance(account.getBalance())})})});
        }
        return TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Address"), TagCreator.th((String)"Key"), TagCreator.th((String)"Balance")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})});
    }

    public void showBlocks(Context ctx) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        Order o = peer.getPeerOrder();
        AVector blocks = o.getBlocks();
        long nblocks = blocks.count();
        long[] range = this.getPaginationRange(ctx, nblocks);
        long start = range[0];
        long limit = range[2];
        DomContent paginationLinks = this.makePaginationLinks(ctx, "/explorer/blocks", start, limit, nblocks);
        this.returnPage(ctx, "Blocks", new String[][]{{"Explorer", ROUTE}, {"Blocks", null}}, new DomContent[]{paginationLinks, this.buildBlocksTable(ctx, (AVector<SignedData<Block>>)blocks, range)});
    }

    private TableTag buildBlocksTable(Context ctx, AVector<SignedData<Block>> blocks, long[] range) {
        long end = range[1];
        long start = range[0];
        if (end - start > 100L) {
            throw new BadRequestResponse("Too many elements requested");
        }
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = start; i < end; ++i) {
            SignedData sd = (SignedData)blocks.get(i);
            String link = "/explorer/blocks/" + i;
            String peerLink = "/explorer/peers/" + sd.getAccountKey().toHexString();
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)Long.toString(i)).withHref(link)}), TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)sd.getAccountKey())}).withHref(peerLink)}), TagCreator.td((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)sd.getHash())})});
        }
        return TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Index"), TagCreator.th((String)"Peer"), TagCreator.th((String)"Block Hash")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})});
    }

    public void showBlock(Context ctx) {
        Peer peer;
        Order o;
        AVector blocks;
        long nblocks;
        Server s = this.restServer.getServer();
        long blockNum = Long.parseLong(ctx.pathParam("blockNum"));
        if (blockNum >= (nblocks = (blocks = (o = (peer = s.getPeer()).getPeerOrder()).getBlocks()).count())) {
            throw new NotFoundResponse("Block " + blockNum + " does not yet exist");
        }
        SignedData sblock = (SignedData)blocks.get(blockNum);
        long blockOffset = blockNum;
        DomContent navLinks = this.makeNavigationLinks("/explorer/blocks", blockOffset, nblocks, "Block");
        this.returnPage(ctx, "Convex Block: " + blockNum, new String[][]{{"Explorer", ROUTE}, {"Blocks", "/explorer/blocks"}, {Long.toString(blockNum), null}}, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{navLinks, TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), this.makeBlockTable((SignedData<Block>)sblock)})}), TagCreator.article((DomContent[])new DomContent[]{this.makeStateTransitionSection(peer, blockNum, ctx)}), TagCreator.article((DomContent[])new DomContent[]{this.makeTransactionsSection((SignedData<Block>)sblock, blockNum, ctx)})});
    }

    private TbodyTag makeBlockTable(SignedData<Block> sblock) {
        AccountKey peerKey = sblock.getAccountKey();
        return TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Block Hash"), TagCreator.td((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)sblock.getHash(), 64)}), TagCreator.td((String)"Hash of block as signed by peer")}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Peer"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)peerKey, 64)}).withHref("/explorer/peers/" + String.valueOf(peerKey))}), TagCreator.td((String)"Peer Ed25519 public key.")}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Signature"), TagCreator.td((DomContent[])new DomContent[]{this.showCVX((ACell)sblock.getSignature())}), TagCreator.td((String)"Ed25519 signature of block (as signed by peer)")}), TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)"Memory"), TagCreator.td((DomContent[])new DomContent[]{TagCreator.code((String)("" + Cells.storageSize(sblock)))}), TagCreator.td((String)"Bytes consumed by blcok data structure")})});
    }

    private DomContent makeTransactionsSection(SignedData<Block> sblock, long blockNum, Context ctx) {
        AVector transactions = ((Block)sblock.getValue()).getTransactions();
        int txCount = transactions.size();
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = 0L; i < (long)txCount; ++i) {
            String txLink = ABaseAPI.getExternalBaseUrl(ctx, "/explorer/blocks/" + blockNum + "/txs/" + i);
            SignedData strans = (SignedData)transactions.get(i);
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)Long.toString(i)).withHref(txLink)}), TagCreator.td((DomContent[])new DomContent[]{ExplorerAPI.identicon((ABlob)strans.getAccountKey()), this.showAddress(((ATransaction)strans.getValue()).getOrigin())}), TagCreator.td((DomContent[])new DomContent[]{this.showCVX((ACell)strans.getHash())})});
        }
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)("Transactions (" + txCount + ")")), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Index"), TagCreator.th((String)"Origin Address"), TagCreator.th((String)"Transaction Hash")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})});
    }

    private DomContent makeStateTransitionSection(Peer peer, long blockNum, Context ctx) {
        State beforeState = null;
        State afterState = null;
        try {
            State state = beforeState = blockNum == 0L ? peer.getGenesisState() : peer.getBlockResult(blockNum - 1L).getState();
            if (blockNum < peer.getPeerOrder().getBlockCount()) {
                afterState = peer.getBlockResult(blockNum).getState();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h5((String)"State Transition"), TagCreator.p((String)"Each block updates the CVM state. For posterity, here's the record of what this block did."), TagCreator.div((DomContent[])new DomContent[]{this.showStateID(beforeState, blockNum), TagCreator.span((String)"  >  ").withStyle("margin: 0.5em"), this.showStateID(afterState, blockNum + 1L)}).withStyle("display: flex; align-items: center;")});
    }

    protected DomContent showStateID(State s, long position) {
        return s == null ? TagCreator.code((String)"<No History>") : TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)s.getHash())}).withHref("/explorer/states/" + position);
    }

    public void showTransaction(Context ctx) {
        Server s = this.restServer.getServer();
        long blockNum = Long.parseLong(ctx.pathParam("blockNum"));
        long txNum = Long.parseLong(ctx.pathParam("txNum"));
        Peer peer = s.getPeer();
        Order o = peer.getPeerOrder();
        AVector blocks = o.getBlocks();
        long nblocks = blocks.count();
        if (blockNum >= nblocks) {
            throw new NotFoundResponse("Block " + blockNum + " does not yet exist");
        }
        SignedData sblock = (SignedData)blocks.get(blockNum);
        AVector transactions = ((Block)sblock.getValue()).getTransactions();
        long txCount = transactions.count();
        if (txNum >= txCount) {
            throw new NotFoundResponse("Transaction " + txNum + " does not exist in block " + blockNum);
        }
        SignedData signedTx = (SignedData)transactions.get(txNum);
        ATransaction trans = (ATransaction)signedTx.getValue();
        long txOffset = txNum;
        DomContent navLinks = this.makeNavigationLinks("/explorer/blocks/" + blockNum + "/txs", txOffset, txCount, "Transaction");
        this.returnPage(ctx, "Transaction " + txNum + " in Block " + blockNum, new String[][]{{"Explorer", ROUTE}, {"Blocks", "/explorer/blocks"}, {Long.toString(blockNum), "/explorer/blocks/" + Long.toString(blockNum)}, {"Transactions", null}, {Long.toString(txNum), null}}, new DomContent[]{navLinks, TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), TagCreator.tbody((DomContent[])new DomContent[]{this.row("Address", (DomContent)TagCreator.div((DomContent[])new DomContent[]{ExplorerAPI.identicon((ABlob)signedTx.getAccountKey()), TagCreator.span().withStyle("margin-right: 0.5em;"), this.showAddress(trans.getOrigin())}), "Origin address of transaction"), this.row("Account Key", ExplorerAPI.showID((AArrayBlob)signedTx.getAccountKey()), "Ed25519 public key of the signer"), this.row("Transaction Hash", ExplorerAPI.showID((AArrayBlob)signedTx.getHash()), "Hash code of the transaction object"), this.row("Type", (DomContent)TagCreator.code((String)trans.getClass().getSimpleName()), "Type of transaction. Most common is 'Invoke' for general purpose execution."), this.row("Transaction Data", (DomContent)this.showCVX((ACell)trans), "CVX representation of the transaction"), this.row("Storage Size", (DomContent)TagCreator.code((String)("" + Cells.storageSize((ACell)signedTx))), "Bytes consumed by transaction data")})}), this.buildTransactionResultView(blockNum, txNum, trans), this.buildTransactionLogsView(blockNum, txNum, trans)});
    }

    private DomContent buildTransactionResultView(long blockNum, long txNum, ATransaction trans) {
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        BlockResult blockResult = peer.getBlockResult(blockNum);
        if (blockResult == null) {
            return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Transaction Result"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"Result not available - block result may have been pruned from history")})})});
        }
        AVector results = blockResult.getResults();
        if (txNum >= results.count()) {
            return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Transaction Result"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"Transaction result not found in block")})})});
        }
        Result result = (Result)results.get(txNum);
        ACell errorCode = result.getErrorCode();
        boolean isError = errorCode != null;
        ACell value = result.getValue();
        AMap info = result.getInfo();
        ArrayList<DomContent> rows = new ArrayList<DomContent>();
        rows.add(this.row("Status", (DomContent)TagCreator.code((String)(isError ? "ERROR" : "SUCCESS")).withClass(isError ? "error-text" : "success-text"), isError ? "Transaction failed with error" : "Transaction executed successfully"));
        rows.add(this.row(isError ? "Error Message" : "Return Value", (DomContent)this.showCVX(value), isError ? "Error message from failed transaction" : "Value returned by transaction"));
        if (isError) {
            String errorDescription = ErrorCodes.getDescription((ACell)errorCode);
            if (errorDescription == null) {
                errorDescription = "CVM error code indicating type of failure";
            }
            rows.add(this.row("Error Code", (DomContent)this.showCVX(errorCode), errorDescription));
        }
        if (info != null) {
            ACell trace;
            ACell mem;
            ACell fees;
            ACell juice = info.get((ACell)Keywords.JUICE);
            if (juice != null) {
                rows.add(this.row("Juice Used", (DomContent)TagCreator.code((String)juice.toString()), "Computational cost in juice units"));
            }
            if ((fees = info.get((ACell)Keywords.FEES)) != null) {
                rows.add(this.row("Fees Paid", this.showBalance(RT.castLong((ACell)fees).longValue()), "Transaction fees paid in Convex Coins"));
            }
            if ((mem = info.get((ACell)Keywords.MEM)) != null) {
                rows.add(this.row("Memory Used", (DomContent)TagCreator.code((String)mem.toString()), "Memory allocated/deallocated (bytes)"));
            }
            if ((trace = info.get((ACell)Keywords.TRACE)) != null) {
                rows.add(this.row("Stack Trace", (DomContent)this.showCVX(trace), "Stack trace for error location"));
            }
        }
        return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Transaction Result"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, r -> r)})})})});
    }

    private DomContent buildTransactionLogsView(long blockNum, long txNum, ATransaction trans) {
        long logCount;
        Server s = this.restServer.getServer();
        Peer peer = s.getPeer();
        BlockResult blockResult = peer.getBlockResult(blockNum);
        if (blockResult == null) {
            return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Log Entries (0)"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"Logs not available - block result may have been pruned from history")})})});
        }
        AVector results = blockResult.getResults();
        if (txNum >= results.count()) {
            return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Log Entries (0)"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"Transaction result not found in block")})})});
        }
        Result result = (Result)results.get(txNum);
        AVector log = result.getLog();
        long l = logCount = log == null ? 0L : log.count();
        if (logCount == 0L) {
            return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Log Entries (0)"), TagCreator.p((DomContent[])new DomContent[]{TagCreator.em((String)"No log entries were generated during transaction execution")})})});
        }
        int maxValuesCount = 1;
        ArrayList<TrTag> logRows = new ArrayList<TrTag>();
        if (log != null) {
            for (long i = 0L; i < logCount; ++i) {
                AVector logEntry = (AVector)log.get(i);
                if (logEntry.count() < 4L) continue;
                ACell address = logEntry.get(0);
                ACell scope = logEntry.get(1);
                ACell position = logEntry.get(2);
                ACell valuesCell = logEntry.get(3);
                ArrayList<TdTag> cells = new ArrayList<TdTag>();
                cells.add(TagCreator.td((DomContent[])new DomContent[]{address != null ? this.showAddress((Address)address) : TagCreator.code((String)"nil")}));
                cells.add(TagCreator.td((DomContent[])new DomContent[]{scope != null ? this.showCVX(scope) : TagCreator.code((String)"nil")}));
                cells.add(TagCreator.td((DomContent[])new DomContent[]{this.showCVX(position)}));
                if (valuesCell instanceof AVector) {
                    AVector values = (AVector)valuesCell;
                    int valuesCount = (int)values.count();
                    maxValuesCount = Math.max(maxValuesCount, valuesCount);
                    for (long j = 0L; j < (long)valuesCount; ++j) {
                        cells.add(TagCreator.td((DomContent[])new DomContent[]{this.showCVX(values.get(j))}));
                    }
                } else {
                    cells.add(TagCreator.td((DomContent[])new DomContent[]{this.showCVX(valuesCell)}));
                }
                logRows.add(TagCreator.tr((DomContent[])cells.toArray(new DomContent[0])));
            }
        }
        return TagCreator.article((DomContent[])new DomContent[]{TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)("Log Entries (" + logCount + ")")), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Address"), TagCreator.th((String)"Scope"), TagCreator.th((String)"Position"), TagCreator.th((String)"Values ...").withCondColspan(maxValuesCount > 1, String.valueOf(maxValuesCount))})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(logRows, row -> row)})})})});
    }

    public void showAccount(Context ctx) {
        Address address;
        Server s = this.restServer.getServer();
        long accountNum = Long.parseLong(ctx.pathParam("accountNum"));
        State state = s.getState();
        AccountStatus account = state.getAccount(address = Address.create((long)accountNum));
        if (account == null) {
            throw new NotFoundResponse("Account " + accountNum + " does not exist");
        }
        this.returnPage(ctx, "Account: #" + accountNum, new String[][]{{"Explorer", ROUTE}, {"Accounts", "/explorer/accounts"}, {"#" + Long.toString(accountNum), null}}, new DomContent[]{TagCreator.article((DomContent[])new DomContent[]{TagCreator.h6((String)("Account " + String.valueOf(address))), this.makeNavigationLinks("/explorer/accounts", accountNum, state.getAccounts().count(), "Account"), this.makeAccountTable(account, address)}), TagCreator.article((DomContent[])new DomContent[]{this.buildAccountFieldsView(account)}), TagCreator.article((DomContent[])new DomContent[]{this.buildEnvironmentView(account)}), TagCreator.article((DomContent[])new DomContent[]{this.buildHoldingsView(account)})});
    }

    private DomContent makeAccountTable(AccountStatus account, Address address) {
        return TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), TagCreator.tbody((DomContent[])new DomContent[]{this.row("Account Key", (DomContent)(account.getAccountKey() != null ? ExplorerAPI.showID((AArrayBlob)account.getAccountKey()) : TagCreator.code((String)"null")), "Ed25519 public key (null for actors)"), this.row("Balance", this.showBalance(account.getBalance()), "Convex coin balance")})});
    }

    private DomContent buildAccountFieldsView(AccountStatus account) {
        return TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)"Account Fields"), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Description")})}), TagCreator.tbody((DomContent[])new DomContent[]{this.row(TagCreator.code((String)":sequence"), TagCreator.code((String)Long.toString(account.getSequence())), TagCreator.text((String)"Number of transactions executed by this account to date.")), this.row(TagCreator.code((String)":key"), account.getAccountKey() == null ? TagCreator.code((String)"nil") : ExplorerAPI.showID((AArrayBlob)account.getAccountKey(), 64), TagCreator.text((String)"Ed25519 public key of this account. If nil, account cannot execute external transactions (e.g. an actor).")), this.row(TagCreator.code((String)":balance"), this.showBalance(account.getBalance()), TagCreator.text((String)"CVM balance of account. This is used for transaction fees and may be freely transferred.")), this.row(TagCreator.code((String)":allowance"), TagCreator.code((String)Long.toString(account.getMemory())), TagCreator.text((String)"Memory allowance credit on the CVM. If positive, the account may allocated up to this amount of memory before incurring fees for additional memory.")), this.row(TagCreator.code((String)":holdings"), Long.toString(account.getHoldings().count()) + " value(s)", TagCreator.text((String)"Storage for holdings data referenced by other accounts.")), this.row(TagCreator.code((String)":controller"), account.getController() == null ? TagCreator.code((String)"nil") : this.showAddress((Address)account.getController()), TagCreator.text((String)"Account controller. If set, the controller can execute code in this account (e.g. change the key). If you don't trust the controller, don't trust the account!")), this.row(TagCreator.code((String)":environment"), Long.toString(account.getEnvironment() == null ? 0L : account.getEnvironment().count()) + " value(s)", TagCreator.text((String)"Symbols defined in this account. Typically used to store data or executable code.")), this.row(TagCreator.code((String)":metadata"), Long.toString(account.getMetadata() == null ? 0L : account.getMetadata().count()) + " value(s)", TagCreator.text((String)"Metadata attached to symbols defined in this account.")), this.row(TagCreator.code((String)":parent"), account.getParent() == null ? TagCreator.code((String)"nil") : this.showAddress(account.getParent()), TagCreator.text((String)"Parent account. This defines fallback values for symbols not defined in this account."))})})});
    }

    private DomContent buildEnvironmentView(AccountStatus account) {
        AHashMap env = account.getEnvironment();
        if (env == null) {
            return TagCreator.summary((String)"No Environment");
        }
        ArrayList<DomContent> rows = new ArrayList<DomContent>();
        long n = env.count();
        int i = 0;
        while ((long)i < n) {
            MapEntry me = env.entryAt((long)i);
            Symbol sym = (Symbol)me.getKey();
            ACell val = me.getValue();
            AHashMap md = account.getMetadata(sym);
            rows.add(this.row(TagCreator.code((String)sym.getName().toString()), this.showCVX(val), this.showCVX(RT.getIn((ACell)md, (ACell[])new ACell[]{Keywords.DOC, Keywords.DESCRIPTION}))));
            ++i;
        }
        return TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)("Environment (" + (n == 0L ? "Empty" : Long.toString(n)) + ")")), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"The Environment contains symbols defined in this account. These may be referenced like: "), TagCreator.code((String)"#45/symbol-name")}), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Symbol"), TagCreator.th((String)"Value"), TagCreator.th((String)"Description")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> row)})})});
    }

    private DomContent buildHoldingsView(AccountStatus account) {
        Index hodls = account.getHoldings();
        if (hodls == null) {
            hodls = Index.none();
        }
        long n = hodls.count();
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        for (long i = 0L; i < n; ++i) {
            MapEntry me = hodls.entryAt(i);
            Address addr = (Address)me.getKey();
            ACell val = me.getValue();
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{this.showAddress(addr)}), TagCreator.td((DomContent[])new DomContent[]{this.showCVX(val)})});
        }
        return TagCreator.details((DomContent[])new DomContent[]{TagCreator.summary((String)("Holdings (" + (n == 0L ? "Empty" : Long.toString(n)) + ")")), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Holdings track token balances and other indexed values by address.")}), TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Address"), TagCreator.th((String)"Value")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})});
    }

    public void showPeers(Context ctx) {
        Server s = this.restServer.getServer();
        State state = s.getState();
        Index peers = state.getPeers();
        long npeers = peers.count();
        long[] range = this.getPaginationRange(ctx, npeers);
        long start = range[0];
        long end = range[1];
        ArrayList<DomContent[]> rows = new ArrayList<DomContent[]>();
        long totalStakeAllPeers = (Long)state.getPeers().reduceValues((acc, ps) -> acc + ps.getBalance(), (Object)0L);
        for (long i = start; i < end; ++i) {
            MapEntry entry = peers.entryAt(i);
            AccountKey peerKey = RT.ensureAccountKey((ACell)entry.getKey());
            PeerStatus peerStatus = (PeerStatus)entry.getValue();
            String peerLink = ABaseAPI.getExternalBaseUrl(ctx, "/explorer/peers/" + peerKey.toHexString());
            double percent = totalStakeAllPeers > 0L ? 100.0 * (double)peerStatus.getBalance() / (double)totalStakeAllPeers : 0.0;
            rows.add(new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{ExplorerAPI.showID((AArrayBlob)peerKey)}).withHref(peerLink)}), TagCreator.td((DomContent[])new DomContent[]{this.showBalance(peerStatus.getBalance())}), TagCreator.td((DomContent[])new DomContent[]{this.showBalance(peerStatus.getPeerStake())}), TagCreator.td((DomContent[])new DomContent[]{this.showBalance(peerStatus.getDelegatedStake())}), TagCreator.td((DomContent[])new DomContent[]{this.showPercent(percent)})});
        }
        String basePath = ABaseAPI.getExternalBaseUrl(ctx, "/explorer/peers");
        DomContent pagination = this.makePaginationLinks(ctx, basePath, start, end - start, npeers);
        this.returnPage(ctx, "Peers", new String[][]{{"Explorer", ROUTE}, {"Peers", null}}, new DomContent[]{pagination, TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Peer Key"), TagCreator.th((String)"Total Stake"), TagCreator.th((String)"Peer Stake"), TagCreator.th((String)"Delegated Stake"), TagCreator.th((String)"Stake")})}), TagCreator.tbody((DomContent[])new DomContent[]{TagCreator.each(rows, row -> TagCreator.tr((DomContent[])row))})})});
    }

    protected DomContent showPercent(double percent) {
        String s = String.format(Locale.US, "%6.2f %%", percent);
        return ExplorerAPI.preCode(s);
    }

    public void showPeerDetail(Context ctx) {
        AccountKey peerKey;
        String peerKeyParam = ctx.pathParam("peerKey");
        try {
            peerKey = AccountKey.parse((String)peerKeyParam);
        }
        catch (Exception e) {
            throw new BadRequestResponse("Invalid peer key format: " + peerKeyParam);
        }
        State state = this.server.getState();
        PeerStatus peerStatus = state.getPeer(peerKey);
        if (peerStatus == null) {
            throw new NotFoundResponse("Peer " + peerKeyParam + " does not exist");
        }
        this.returnPage(ctx, "Peer: " + peerKey.toHexString(), new String[][]{{"Explorer", ROUTE}, {"Peers", "/explorer/peers"}, {peerKey.toHexString(8) + "...", null}}, new DomContent[]{TagCreator.table((DomContent[])new DomContent[]{TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"Field"), TagCreator.th((String)"Value"), TagCreator.th((String)"Notes")})}), this.makePeerTable(peerStatus, peerKey)})});
    }

    private TbodyTag makePeerTable(PeerStatus peerStatus, AccountKey peerKey) {
        return TagCreator.tbody((DomContent[])new DomContent[]{this.row("Peer Key", ExplorerAPI.showID((AArrayBlob)peerKey, 64), "Public key of the peer"), this.row("Controller", this.showAddress(peerStatus.getController()), "Controller address for this peer"), this.row("Total Stake", this.showBalance(peerStatus.getBalance()), "Total stake (peer + delegated) in CVM"), this.row("Peer Stake", this.showBalance(peerStatus.getPeerStake()), "Peer's own stake in CVM"), this.row("Delegated Stake", this.showBalance(peerStatus.getDelegatedStake()), "Stake delegated to this peer in CVM"), this.row("Last Block", this.timestamp(peerStatus.getTimestamp()), "Timestamp of last block issued by this peer"), this.row("Hostname", (DomContent)(peerStatus.getHostname() != null ? TagCreator.code((String)peerStatus.getHostname().toString()) : TagCreator.code((String)"<not defined>")), "Hostname/URL for peer connections"), this.row("Metadata", (DomContent)this.showCVX((ACell)peerStatus.getMetadata()), "Metadata provide by peer operator"), this.row("Storage Size", (DomContent)TagCreator.code((String)("" + Cells.storageSize((ACell)peerStatus))), "Bytes consumed by peer status data structure")});
    }

    public void showRepl(Context ctx) {
        this.returnPage(ctx, "Convex REPL", new String[][]{{"Explorer", ROUTE}, {"REPL", null}}, new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)"Run dynamic queries with the Convex REPL"), TagCreator.small((String)"Enter: execute | Shift+Enter: new line | Ctrl+Enter: force execute | Ctrl+Up/Down: history"), ((DivTag)TagCreator.div().withId("repl-output")).withClass("repl-output"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.label((String)"Account:"), ((InputTag)((InputTag)((InputTag)((InputTag)((InputTag)((InputTag)TagCreator.input().withType("text")).withId("repl-account")).withValue("#11")).withPlaceholder("#11")).attr("list", (Object)"account-list")).attr("pattern", (Object)"^#[0-9]+$")).withStyle("width: 120px; margin-right: 1em;"), TagCreator.datalist((DomContent[])new DomContent[]{TagCreator.option((String)"#8"), TagCreator.option((String)"#11")}).withId("account-list"), ((ButtonTag)TagCreator.button((String)"Execute").withId("repl-execute")).withStyle("margin-right: 0.5em;"), ((ButtonTag)TagCreator.button((String)"Clear").withId("repl-clear")).withClass("secondary")}), ((TextareaTag)((TextareaTag)((TextareaTag)TagCreator.textarea().withId("repl-input")).withClass("repl-input")).withPlaceholder("Enter Convex Lisp code here...\nExample: (* 2 3)")).attr("rows", (Object)"4")}).withClass("repl-input-area")}).withClass("repl-container"), ((ScriptTag)TagCreator.script().withSrc("/js/repl.js")).withType("text/javascript")});
    }

    public void handleSearch(Context ctx) {
        String query = ctx.formParam("q");
        if (query == null || query.trim().isEmpty()) {
            ctx.redirect(ROUTE);
            return;
        }
        Peer peer = this.server.getPeer();
        query = query.trim();
        try {
            String numStr = query.startsWith("#") ? query.substring(1) : query;
            long accountNum = Long.parseLong(numStr);
            if (accountNum >= 0L) {
                ctx.redirect("/explorer/accounts/" + accountNum);
                return;
            }
        }
        catch (NumberFormatException numStr) {
            // empty catch block
        }
        Blob blob = Blob.parse((String)query);
        if (blob != null && blob.count() == 32L) {
            AccountKey peerKey = AccountKey.create((ABlob)blob);
            if (peer.getConsensusState().getPeer(peerKey) != null) {
                ctx.redirect("/explorer/peers/" + peerKey.toHexString());
                return;
            }
            Hash hash = Hash.wrap((AArrayBlob)blob);
            if (hash != null) {
                CVMLong blockIndexCell = peer.getBlockIndex(hash);
                if (blockIndexCell != null) {
                    ctx.redirect("/explorer/blocks/" + blockIndexCell.longValue());
                    return;
                }
                AVector loc = peer.getTransactionLocation(hash);
                if (loc != null && loc.count() >= 2L) {
                    long blockIndex = ((CVMLong)loc.get(0)).longValue();
                    long txIndex = ((CVMLong)loc.get(1)).longValue();
                    ctx.redirect("/explorer/blocks/" + blockIndex + "/txs/" + txIndex);
                    return;
                }
            }
        }
        this.returnPage(ctx, "Couldn't find what you were looking for", new DomContent[]{TagCreator.h6((String)("Couldn't find search term: " + query)), this.searchBox()});
    }
}

