/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.mcp;

import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.Strings;
import convex.core.exceptions.ParseException;
import convex.core.json.JSON5Reader;
import convex.core.lang.RT;
import java.io.IOException;
import java.io.InputStream;

public abstract class McpTool {
    private final AMap<AString, ACell> metadata;
    private final String name;

    protected McpTool(AMap<AString, ACell> metadata) {
        this.metadata = metadata;
        AString nameCell = RT.ensureString((ACell)metadata.get((ACell)Strings.create((String)"name")));
        if (nameCell == null) {
            throw new IllegalArgumentException("Tool metadata missing 'name'");
        }
        this.name = nameCell.toString();
    }

    public String getName() {
        return this.name;
    }

    public AMap<AString, ACell> getMetadata() {
        return this.metadata;
    }

    public abstract AMap<AString, ACell> handle(AMap<AString, ACell> var1);

    public static AMap<AString, ACell> loadMetadata(String resourcePath) {
        AMap aMap;
        block10: {
            InputStream is = McpTool.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("Tool metadata resource not found: " + resourcePath);
                }
                ACell cell = JSON5Reader.read((InputStream)is);
                AMap metadata = RT.ensureMap((ACell)cell);
                if (metadata == null) {
                    throw new IllegalStateException("Tool metadata must be a JSON object: " + resourcePath);
                }
                aMap = metadata;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException | IOException e) {
                    throw new IllegalStateException("Failed to read tool metadata: " + resourcePath, e);
                }
            }
            is.close();
        }
        return aMap;
    }
}

