/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.data.Keyword;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.peer.API;
import convex.peer.ConfigException;
import convex.peer.LaunchException;
import convex.peer.Server;
import convex.restapi.api.ChainAPI;
import convex.restapi.api.DLAPI;
import convex.restapi.api.DepAPI;
import convex.restapi.api.McpAPI;
import convex.restapi.api.X402;
import convex.restapi.web.ExplorerAPI;
import convex.restapi.web.PeerAdminAPI;
import convex.restapi.web.WebApp;
import io.javalin.Javalin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.staticfiles.Location;
import io.javalin.openapi.JsonSchemaLoader;
import io.javalin.openapi.JsonSchemaResource;
import io.javalin.openapi.plugin.DefinitionConfiguration;
import io.javalin.openapi.plugin.OpenApiPlugin;
import io.javalin.openapi.plugin.redoc.ReDocPlugin;
import io.javalin.openapi.plugin.swagger.SwaggerPlugin;
import io.javalin.plugin.Plugin;
import io.javalin.util.JavalinException;
import java.io.Closeable;
import java.util.HashMap;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServer
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger((String)RESTServer.class.getName());
    protected final Server server;
    protected final Convex convex;
    protected Javalin javalin;
    protected static final Integer DEFAULT_PORT = 8080;
    protected ChainAPI chainAPI;
    protected DepAPI depAPI;
    protected DLAPI dlAPI;
    protected WebApp webApp;
    protected PeerAdminAPI peerAPI;
    protected ExplorerAPI explorerAPI;
    protected McpAPI mcpAPI;
    protected X402 x402API;
    private final Convex convexFaucet;

    private RESTServer(Server server) {
        this.server = server;
        this.convex = ConvexLocal.create((Server)server);
        this.convexFaucet = RT.bool((Object)this.getConfig().get(ChainAPI.K_FAUCET)) ? ConvexLocal.create((Server)server, (Address)server.getPeerController(), (AKeyPair)server.getKeyPair()) : null;
    }

    public McpAPI getMcpAPI() {
        return this.mcpAPI;
    }

    private void addAPIRoutes(Javalin app) {
        this.chainAPI = new ChainAPI(this);
        this.chainAPI.addRoutes(app);
        this.depAPI = new DepAPI(this);
        this.depAPI.addRoutes(app);
        this.peerAPI = new PeerAdminAPI(this);
        this.peerAPI.addRoutes(app);
        this.webApp = new WebApp(this);
        this.webApp.addRoutes(app);
        this.dlAPI = new DLAPI(this);
        this.dlAPI.addRoutes(app);
        this.explorerAPI = new ExplorerAPI(this);
        this.explorerAPI.addRoutes(app);
        this.mcpAPI = new McpAPI(this);
        this.mcpAPI.addRoutes(app);
        this.x402API = new X402(this);
        this.x402API.addRoutes(app);
    }

    private Javalin buildApp(boolean useSSL) {
        Javalin app = Javalin.create((T config) -> {
            config.bundledPlugins.enableCors(cors -> cors.addRule(corsConfig -> corsConfig.anyHost()));
            this.addOpenApiPlugins((JavalinConfig)config);
            config.staticFiles.add(staticFiles -> {
                staticFiles.hostedPath = "/";
                staticFiles.location = Location.CLASSPATH;
                staticFiles.directory = "/convex/restapi/pub";
                staticFiles.precompress = false;
                staticFiles.aliasCheck = null;
                staticFiles.skipFileFunction = req -> false;
            });
            config.useVirtualThreads = true;
        });
        app.exception(Exception.class, (e, ctx) -> {
            e.printStackTrace();
            String message = "Unexpected error: " + String.valueOf(e);
            ctx.result(message);
            ctx.status(500);
        });
        app.options("/*", ctx -> {
            ctx.status(204);
            ctx.removeHeader("Content-type");
            ctx.header("access-control-allow-headers", "content-type");
            ctx.header("access-control-allow-methods", "GET,HEAD,PUT,PATCH,POST,DELETE");
            ctx.header("access-control-allow-origin", "*");
            ctx.header("vary", "Origin, Access-Control-Request-Headers");
        });
        app.afterMatched(ctx -> {
            String origin = ctx.req().getHeader("Origin");
            if (origin != null) {
                ctx.header("access-control-allow-origin", "*");
            } else {
                ctx.header("access-control-allow-origin", "*");
            }
        });
        this.addAPIRoutes(app);
        return app;
    }

    protected void addOpenApiPlugins(JavalinConfig config) {
        String docsPath = "/openapi";
        config.registerPlugin((Plugin)new OpenApiPlugin(pluginConfig -> pluginConfig.withDocumentationPath(docsPath).withDefinitionConfiguration((version, definition) -> {
            DefinitionConfiguration def = definition;
            def = def.withInfo(info -> {
                info.setTitle("Convex REST API");
                info.setVersion(Utils.getVersion());
            });
        })));
        config.registerPlugin((Plugin)new SwaggerPlugin(swaggerConfiguration -> swaggerConfiguration.setDocumentationPath(docsPath)));
        config.registerPlugin((Plugin)new ReDocPlugin(reDocConfiguration -> reDocConfiguration.setDocumentationPath(docsPath)));
        for (JsonSchemaResource generatedJsonSchema : new JsonSchemaLoader().loadGeneratedSchemes()) {
            System.out.println(generatedJsonSchema.getName());
        }
    }

    public static RESTServer create(Server server) {
        RESTServer newServer = new RESTServer(server);
        return newServer;
    }

    public static RESTServer create(Convex convex) {
        return RESTServer.create(convex.getLocalServer());
    }

    protected void setupJettyServer(org.eclipse.jetty.server.Server jettyServer, Integer port) {
        if (port == null) {
            port = DEFAULT_PORT;
        }
        ServerConnector connector = new ServerConnector(jettyServer);
        connector.setPort(port.intValue());
        jettyServer.addConnector((Connector)connector);
    }

    public void start() {
        this.start(null);
    }

    public synchronized void start(Integer port) {
        this.close();
        try {
            this.javalin = this.buildApp(true);
            this.start(this.javalin, port);
        }
        catch (JavalinException e) {
            if (port != null) {
                throw e;
            }
            log.warn("Specified port " + port + "already in use, chosing another at random");
            this.close();
            port = 0;
            this.javalin = this.buildApp(false);
            this.start(this.javalin, port);
        }
    }

    protected void start(Javalin app, Integer port) {
        org.eclipse.jetty.server.Server jettyServer = app.jettyServer().server();
        this.setupJettyServer(jettyServer, port);
        app.start();
    }

    @Override
    public synchronized void close() {
        if (this.javalin != null) {
            this.javalin.stop();
        }
        this.javalin = null;
    }

    public Convex getConvex() {
        return this.convex;
    }

    public Convex getFaucet() {
        return this.convexFaucet;
    }

    public Server getServer() {
        return this.server;
    }

    public int getPort() {
        if (this.javalin == null) {
            throw new Error("Javalin not started");
        }
        return this.javalin.port();
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.server.getConfig();
    }

    public String getBaseURL() {
        Object o = this.server.getConfig().get(Keywords.BASE_URL);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException, ConfigException, LaunchException {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        AKeyPair kp = AKeyPair.createSeeded((long)88888888L);
        config.put(Keywords.KEYPAIR, kp);
        config.put(Keyword.create((String)"faucet"), true);
        Server s = API.launchPeer(config);
        System.out.println("Using Ed25519 seed:   " + String.valueOf(s.getKeyPair().getSeed()));
        System.out.println("Using peer port:      " + s.getPort());
        ConvexLocal c = Convex.connect((Server)s);
        c.setAddress(Address.create((long)12L), kp);
        c.transact("(log :TEST)");
        c.transact(":test-transaction");
        c.transact("(def TOKEN (deploy (@convex.fungible/build-token {:supply 1000000})))");
        c.transact("(@convex.asset/transfer #13 [TOKEN 1337])");
        try (RESTServer rs = RESTServer.create(s);){
            rs.start();
            System.out.println("Started on REST port: " + rs.getPort());
            while (s.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        System.out.println("Server shutting down.... bye!");
    }
}

